/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.util.collection.ArrayUtils;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.AuthenticatedCollectionResource;
import org.rhq.gui.webdav.RootFolder;

public class WebDAVResourceFactory
implements ResourceFactory {
    private static final Log LOG = LogFactory.getLog(WebDAVResourceFactory.class);

    public Resource getResource(String host, String url) {
        String webdavResourceType;
        Resource foundResource = null;
        String[] paths = url.split("/");
        if (paths.length >= 3 && "resource".equals(webdavResourceType = paths[2])) {
            foundResource = this.getResourceResource(this.getSubarray(paths, 3));
        }
        if (foundResource == null) {
            LOG.warn((Object)("Couldn't find resource associated with webdav url [" + url + "]"));
        }
        return foundResource;
    }

    public String getSupportedLevels() {
        return "1";
    }

    private String[] getSubarray(String[] full, int index) {
        return (String[])ArrayUtils.copyOfRange((Object[])full, (int)index, (int)full.length);
    }

    public Subject getOverlord() {
        return LookupUtil.getSubjectManager().getOverlord();
    }

    private Resource getResourceResource(String[] paths) {
        if (paths.length == 0 || paths[0] == null || paths[0].length() == 0) {
            return new RootFolder();
        }
        RootFolder resourceFolder = new RootFolder();
        for (int i = 0; i < paths.length; ++i) {
            boolean found = false;
            if (resourceFolder instanceof AuthenticatedCollectionResource) {
                List children = ((AuthenticatedCollectionResource)resourceFolder).getChildren(this.getOverlord());
                for (Resource child : children) {
                    String childName = child.getName();
                    if (!childName.equals(paths[i])) continue;
                    resourceFolder = child;
                    found = true;
                }
            }
            if (found) continue;
            return null;
        }
        return resourceFolder;
    }
}

