/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Request;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.Authenticator;

public abstract class BasicResource
extends Authenticator
implements PropFindableResource {
    private static final Log LOG = LogFactory.getLog(BasicResource.class);
    private final Resource managedResource;

    public BasicResource(Subject subject, Resource managedResource) {
        super(subject);
        if (managedResource == null) {
            throw new NullPointerException("managedResource == null");
        }
        this.managedResource = managedResource;
    }

    protected Resource getManagedResource() {
        return this.managedResource;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        boolean authorized = false;
        if (auth != null) {
            Subject subject = (Subject)auth.getTag();
            if (subject != null) {
                AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
                authorized = authorizationManager.canViewResource(subject, this.getManagedResource().getId());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BasicResource [" + this.getManagedResource() + "], auth=[" + auth.getTag() + "], isAuthorized=" + authorized));
            }
        }
        return authorized;
    }

    public String checkRedirect(Request request) {
        return null;
    }
}

