/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.gui.webdav;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.resource.Resource;
import org.rhq.enterprise.server.measurement.MeasurementDataManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.gui.webdav.GetableBasicResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitsResource
extends GetableBasicResource {
    private List<MeasurementDataTrait> traits;
    private String content;

    public TraitsResource(Subject subject, Resource managedResource) {
        super(subject, managedResource);
    }

    public String getUniqueId() {
        return "traits_" + this.getManagedResource().getId();
    }

    public String getName() {
        return "measurement_traits.xml";
    }

    public Date getModifiedDate() {
        long latestTimestamp = 0L;
        for (MeasurementDataTrait trait : this.getTraits()) {
            if (latestTimestamp >= trait.getTimestamp()) continue;
            latestTimestamp = trait.getTimestamp();
        }
        return new Date(latestTimestamp);
    }

    public Date getCreateDate() {
        return new Date(this.getManagedResource().getCtime());
    }

    protected String loadContent() {
        if (this.content == null) {
            StringBuilder str = new StringBuilder();
            str.append("<?xml version=\"1.0\"?>\n");
            str.append("<traits>\n");
            for (MeasurementDataTrait trait : this.getTraits()) {
                str.append("   <trait>\n");
                str.append("      <name>").append(trait.getName()).append("</name>\n");
                str.append("      <value>").append(trait.getValue()).append("</value>\n");
                str.append("      <last-changed>").append(new Date(trait.getTimestamp())).append("</last-changed>\n");
                str.append("      <schedule-id>").append(trait.getScheduleId()).append("</schedule-id>\n");
                str.append("   </trait>\n");
            }
            str.append("</traits>\n");
            this.content = str.toString();
        }
        return this.content;
    }

    private List<MeasurementDataTrait> getTraits() {
        if (this.traits == null) {
            MeasurementDataManagerLocal mdm = LookupUtil.getMeasurementDataManager();
            List traits = mdm.findCurrentTraitsForResource(this.getSubject(), this.getManagedResource().getId(), null);
            this.traits = traits != null ? traits : new ArrayList();
        }
        return this.traits;
    }
}

