/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.safeinvoker;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateDetachUtility {
    private static final Log LOG = LogFactory.getLog(HibernateDetachUtility.class);

    public static void nullOutUninitializedFields(Object value, SerializationType serializationType) throws Exception {
        long start = System.currentTimeMillis();
        HashSet<Integer> checkedObjs = new HashSet<Integer>();
        HibernateDetachUtility.nullOutUninitializedFields(value, checkedObjs, 0, serializationType);
        long duration = System.currentTimeMillis() - start;
        if (duration > 1000L) {
            LOG.info((Object)("Detached [" + checkedObjs.size() + "] objects in [" + duration + "]ms"));
        } else {
            LOG.debug((Object)("Detached [" + checkedObjs.size() + "] objects in [" + duration + "]ms"));
        }
    }

    private static void nullOutUninitializedFields(Object value, Set<Integer> nulledObjects, int depth, SerializationType serializationType) throws Exception {
        if (depth > 50) {
            LOG.warn((Object)("Getting different object hierarchies back from calls: " + value.getClass().getName()));
            return;
        }
        if (value == null || nulledObjects.contains(System.identityHashCode(value))) {
            return;
        }
        nulledObjects.add(System.identityHashCode(value));
        if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            for (int i = 0; i < objArray.length; ++i) {
                HibernateDetachUtility.nullOutUninitializedFields(objArray[i], nulledObjects, depth + 1, serializationType);
            }
        } else if (value instanceof List) {
            ListIterator<Object> i = ((List)value).listIterator();
            while (i.hasNext()) {
                Object val = i.next();
                Object replace = HibernateDetachUtility.replaceObject(val);
                if (replace != null) {
                    val = replace;
                    i.set(replace);
                }
                HibernateDetachUtility.nullOutUninitializedFields(val, nulledObjects, depth + 1, serializationType);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList itemsToBeReplaced = new ArrayList();
            ArrayList<Object> replacementItems = new ArrayList<Object>();
            for (Object item : collection) {
                Object replacementItem = HibernateDetachUtility.replaceObject(item);
                if (replacementItem != null) {
                    itemsToBeReplaced.add(item);
                    replacementItems.add(replacementItem);
                    item = replacementItem;
                }
                HibernateDetachUtility.nullOutUninitializedFields(item, nulledObjects, depth + 1, serializationType);
            }
            collection.removeAll(itemsToBeReplaced);
            collection.addAll(replacementItems);
        } else if (value instanceof Map) {
            for (Object key : ((Map)value).keySet()) {
                HibernateDetachUtility.nullOutUninitializedFields(((Map)value).get(key), nulledObjects, depth + 1, serializationType);
                HibernateDetachUtility.nullOutUninitializedFields(key, nulledObjects, depth + 1, serializationType);
            }
        } else if (value instanceof Enum) {
            return;
        }
        if (serializationType == SerializationType.JAXB) {
            XmlAccessorType at = value.getClass().getAnnotation(XmlAccessorType.class);
            if (at != null && at.value() == XmlAccessType.FIELD) {
                HibernateDetachUtility.nullOutFieldsByFieldAccess(value, nulledObjects, depth, serializationType);
            } else {
                HibernateDetachUtility.nullOutFieldsByAccessors(value, nulledObjects, depth, serializationType);
            }
        } else if (serializationType == SerializationType.SERIALIZATION) {
            HibernateDetachUtility.nullOutFieldsByFieldAccess(value, nulledObjects, depth, serializationType);
        }
    }

    private static void nullOutFieldsByFieldAccess(Object object, Set<Integer> nulledObjects, int depth, SerializationType serializationType) throws Exception {
        ArrayList<Field> fieldsToClean = new ArrayList<Field>();
        for (Class<?> tmpClass = object.getClass(); tmpClass != null && tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
            Collections.addAll(fieldsToClean, tmpClass.getDeclaredFields());
        }
        HibernateDetachUtility.nullOutFieldsByFieldAccess(object, fieldsToClean, nulledObjects, depth, serializationType);
    }

    private static void nullOutFieldsByFieldAccess(Object object, List<Field> classFields, Set<Integer> nulledObjects, int depth, SerializationType serializationType) throws Exception {
        boolean accessModifierFlag = false;
        for (Field field : classFields) {
            AbstractCollection replacement;
            Object fieldValue;
            accessModifierFlag = false;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                accessModifierFlag = true;
            }
            if ((fieldValue = field.get(object)) instanceof HibernateProxy) {
                replacement = null;
                if (fieldValue.getClass().getName().contains("javassist")) {
                    Class<?> assistClass = fieldValue.getClass();
                    try {
                        Method m = assistClass.getMethod("writeReplace", new Class[0]);
                        replacement = m.invoke(fieldValue, new Object[0]);
                        String className = fieldValue.getClass().getName();
                        className = className.substring(0, className.indexOf("_$$_"));
                        if (!replacement.getClass().getName().contains("hibernate")) {
                            HibernateDetachUtility.nullOutUninitializedFields(replacement, nulledObjects, depth + 1, serializationType);
                            field.set(object, replacement);
                        } else {
                            replacement = null;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Unable to write replace object " + fieldValue.getClass());
                    }
                }
                if (replacement == null) {
                    String className = ((HibernateProxy)fieldValue).getHibernateLazyInitializer().getEntityName();
                    Class<?> clazz = Class.forName(className);
                    Class[] constArgs = new Class[]{Integer.class};
                    Constructor<?> construct = null;
                    try {
                        construct = clazz.getConstructor(constArgs);
                        replacement = construct.newInstance((Integer)((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        field.set(object, replacement);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            Field idField = clazz.getDeclaredField("id");
                            Constructor<?> ct = clazz.getDeclaredConstructor(new Class[0]);
                            ct.setAccessible(true);
                            replacement = ct.newInstance(new Object[0]);
                            if (!idField.isAccessible()) {
                                idField.setAccessible(true);
                            }
                            idField.set(replacement, (Integer)((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("No id constructor and unable to set field id for base bean " + className);
                        }
                        field.set(object, replacement);
                    }
                }
            } else if (fieldValue instanceof PersistentCollection) {
                if (!((PersistentCollection)fieldValue).wasInitialized()) {
                    field.set(object, null);
                } else {
                    replacement = null;
                    if (fieldValue instanceof Map) {
                        replacement = new HashMap((Map)fieldValue);
                    } else if (fieldValue instanceof List) {
                        replacement = new ArrayList((List)fieldValue);
                    } else if (fieldValue instanceof Set) {
                        replacement = new HashSet((Set)fieldValue);
                    } else if (fieldValue instanceof Collection) {
                        replacement = new ArrayList((Collection)fieldValue);
                    }
                    HibernateDetachUtility.setField(object, field.getName(), replacement);
                    HibernateDetachUtility.nullOutUninitializedFields(replacement, nulledObjects, depth + 1, serializationType);
                }
            } else if (fieldValue != null && (fieldValue.getClass().getName().contains("org.rhq") || fieldValue instanceof Collection || fieldValue instanceof Object[] || fieldValue instanceof Map)) {
                HibernateDetachUtility.nullOutUninitializedFields(fieldValue, nulledObjects, depth + 1, serializationType);
            }
            if (!accessModifierFlag) continue;
            field.setAccessible(false);
        }
    }

    private static Object replaceObject(Object object) {
        Object replacement = null;
        if (object instanceof HibernateProxy && object.getClass().getName().contains("javassist")) {
            Class<?> assistClass = object.getClass();
            try {
                Method m = assistClass.getMethod("writeReplace", new Class[0]);
                replacement = m.invoke(object, new Object[0]);
                String className = object.getClass().getName();
            }
            catch (Exception e) {
                System.out.println("Unable to write replace object " + object.getClass());
            }
        }
        return replacement;
    }

    private static void nullOutFieldsByAccessors(Object value, Set<Integer> nulledObjects, int depth, SerializationType serializationType) throws Exception {
        PropertyDescriptor[] pds;
        BeanInfo bi = Introspector.getBeanInfo(value.getClass(), Object.class);
        for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
            Object propertyValue;
            block8: {
                propertyValue = null;
                try {
                    propertyValue = pd.getReadMethod().invoke(value, new Object[0]);
                }
                catch (Throwable lie) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)("Couldn't load: " + pd.getName() + " off of " + value.getClass().getSimpleName()), lie);
                }
            }
            if (!Hibernate.isInitialized((Object)propertyValue)) {
                try {
                    Method writeMethod;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Nulling out: " + pd.getName() + " off of " + value.getClass().getSimpleName()));
                    }
                    if ((writeMethod = pd.getWriteMethod()) != null && writeMethod.getAnnotation(XmlTransient.class) == null) {
                        pd.getWriteMethod().invoke(value, new Object[]{null});
                        continue;
                    }
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                catch (Exception lie) {
                    LOG.debug((Object)("Couldn't null out: " + pd.getName() + " off of " + value.getClass().getSimpleName() + " trying field access"), (Throwable)lie);
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                continue;
            }
            if (!(propertyValue instanceof Collection) && (propertyValue == null || !propertyValue.getClass().getName().startsWith("org.rhq.core.domain"))) continue;
            HibernateDetachUtility.nullOutUninitializedFields(propertyValue, nulledObjects, depth + 1, serializationType);
        }
    }

    private static void setField(Object object, String fieldName, Object newValue) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(object, newValue);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void nullOutField(Object value, String fieldName) {
        try {
            Field f = value.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(value, null);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SerializationType {
        SERIALIZATION,
        JAXB;

    }
}

