/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.proxy.HibernateProxy;

public class HibernateDetachUtility {
    private static final Log LOG;
    private static final String DEPTH_ALLOWED_SYSPROP = "rhq.server.hibernate-detach-utility.depth-allowed";
    private static final int depthAllowed;

    public static void nullOutUninitializedFields(Object value, SerializationType serializationType) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<Integer, Object> checkedObjects = new HashMap<Integer, Object>();
        HibernateDetachUtility.nullOutUninitializedFields(value, checkedObjects, 0, serializationType);
        long duration = System.currentTimeMillis() - start;
        if (duration > 1000L) {
            LOG.info((Object)("Detached [" + checkedObjects.size() + "] objects in [" + duration + "]ms"));
        } else {
            LOG.debug((Object)("Detached [" + checkedObjects.size() + "] objects in [" + duration + "]ms"));
        }
        checkedObjects.clear();
    }

    private static void nullOutUninitializedFields(Object value, Map<Integer, Object> checkedObjects, int depth, SerializationType serializationType) throws Exception {
        if (depth > depthAllowed) {
            LOG.warn((Object)("Recursed too deep [" + depth + " > " + depthAllowed + "], will not attempt to detach object of type [" + (value != null ? value.getClass().getName() : "N/A") + "]. This may cause serialization errors later. If so, " + "you can try to work around this by setting the system property [" + DEPTH_ALLOWED_SYSPROP + "] to a value higher than [" + depth + "]."));
            return;
        }
        if (null == value) {
            return;
        }
        Integer valueIdentity = System.identityHashCode(value);
        Object checkedObject = checkedObjects.get(valueIdentity);
        if (null == checkedObject) {
            checkedObjects.put(valueIdentity, value);
        } else {
            if (value == checkedObject) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("UNEQUAL IDENTITY HASHCODE [" + valueIdentity + "]\n\tCurrent  : " + value.getClass().getName() + "\n\t" + value + "\n\tPrevious: " + checkedObject.getClass().getName() + "\n\t" + checkedObject));
            }
        }
        if (value instanceof Object[]) {
            Object[] objArray = (Object[])value;
            for (int i = 0; i < objArray.length; ++i) {
                HibernateDetachUtility.nullOutUninitializedFields(objArray[i], checkedObjects, depth + 1, serializationType);
            }
        } else if (value instanceof List) {
            ListIterator<Object> i = ((List)value).listIterator();
            while (i.hasNext()) {
                Object val = i.next();
                Object replace = HibernateDetachUtility.replaceObject(val);
                if (replace != null) {
                    val = replace;
                    i.set(replace);
                }
                HibernateDetachUtility.nullOutUninitializedFields(val, checkedObjects, depth + 1, serializationType);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList itemsToBeReplaced = new ArrayList();
            ArrayList<Object> replacementItems = new ArrayList<Object>();
            for (Object item : collection) {
                Object replacementItem = HibernateDetachUtility.replaceObject(item);
                if (replacementItem != null) {
                    itemsToBeReplaced.add(item);
                    replacementItems.add(replacementItem);
                    item = replacementItem;
                }
                HibernateDetachUtility.nullOutUninitializedFields(item, checkedObjects, depth + 1, serializationType);
            }
            collection.removeAll(itemsToBeReplaced);
            collection.addAll(replacementItems);
        } else if (value instanceof Map) {
            for (Object key : ((Map)value).keySet()) {
                HibernateDetachUtility.nullOutUninitializedFields(((Map)value).get(key), checkedObjects, depth + 1, serializationType);
                HibernateDetachUtility.nullOutUninitializedFields(key, checkedObjects, depth + 1, serializationType);
            }
        } else if (value instanceof Enum) {
            return;
        }
        if (serializationType == SerializationType.JAXB) {
            XmlAccessorType at = value.getClass().getAnnotation(XmlAccessorType.class);
            if (at != null && at.value() == XmlAccessType.FIELD) {
                HibernateDetachUtility.nullOutFieldsByFieldAccess(value, checkedObjects, depth, serializationType);
            } else {
                HibernateDetachUtility.nullOutFieldsByAccessors(value, checkedObjects, depth, serializationType);
            }
        } else if (serializationType == SerializationType.SERIALIZATION) {
            HibernateDetachUtility.nullOutFieldsByFieldAccess(value, checkedObjects, depth, serializationType);
        }
    }

    private static void nullOutFieldsByFieldAccess(Object object, Map<Integer, Object> checkedObjects, int depth, SerializationType serializationType) throws Exception {
        ArrayList<Field> fieldsToClean = new ArrayList<Field>();
        for (Class<?> tmpClass = object.getClass(); tmpClass != null && tmpClass != Object.class; tmpClass = tmpClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = tmpClass.getDeclaredFields()) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                fieldsToClean.add(declaredField);
            }
        }
        HibernateDetachUtility.nullOutFieldsByFieldAccess(object, fieldsToClean, checkedObjects, depth, serializationType);
    }

    private static void nullOutFieldsByFieldAccess(Object object, List<Field> classFields, Map<Integer, Object> checkedObjects, int depth, SerializationType serializationType) throws Exception {
        boolean accessModifierFlag = false;
        for (Field field : classFields) {
            AbstractCollection replacement;
            Object fieldValue;
            accessModifierFlag = false;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                accessModifierFlag = true;
            }
            if ((fieldValue = field.get(object)) instanceof HibernateProxy) {
                replacement = null;
                if (fieldValue.getClass().getName().contains("javassist")) {
                    Class<?> assistClass = fieldValue.getClass();
                    try {
                        Method m = assistClass.getMethod("writeReplace", new Class[0]);
                        replacement = m.invoke(fieldValue, new Object[0]);
                        String className = fieldValue.getClass().getName();
                        className = className.substring(0, className.indexOf("_$$_"));
                        if (!replacement.getClass().getName().contains("hibernate")) {
                            HibernateDetachUtility.nullOutUninitializedFields(replacement, checkedObjects, depth + 1, serializationType);
                            field.set(object, replacement);
                        } else {
                            replacement = null;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Unable to write replace object " + fieldValue.getClass()), (Throwable)e);
                    }
                }
                if (replacement == null) {
                    String className = ((HibernateProxy)fieldValue).getHibernateLazyInitializer().getEntityName();
                    Class<?> clazz = Class.forName(className);
                    Class[] constArgs = new Class[]{Integer.class};
                    Constructor<?> construct = null;
                    try {
                        construct = clazz.getConstructor(constArgs);
                        replacement = construct.newInstance((Integer)((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        field.set(object, replacement);
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            Field idField = clazz.getDeclaredField("id");
                            Constructor<?> ct = clazz.getDeclaredConstructor(new Class[0]);
                            ct.setAccessible(true);
                            replacement = ct.newInstance(new Object[0]);
                            if (!idField.isAccessible()) {
                                idField.setAccessible(true);
                            }
                            idField.set(replacement, (Integer)((HibernateProxy)fieldValue).getHibernateLazyInitializer().getIdentifier());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            LOG.error((Object)("No id constructor and unable to set field id for base bean " + className), (Throwable)e);
                        }
                        field.set(object, replacement);
                    }
                }
            } else if (fieldValue instanceof PersistentCollection) {
                if (!((PersistentCollection)fieldValue).wasInitialized()) {
                    field.set(object, null);
                } else {
                    replacement = null;
                    boolean needToNullOutFields = true;
                    if (fieldValue instanceof Map) {
                        replacement = new HashMap((Map)fieldValue);
                    } else if (fieldValue instanceof List) {
                        replacement = new ArrayList((List)fieldValue);
                    } else if (fieldValue instanceof Set) {
                        ArrayList l = new ArrayList((Set)fieldValue);
                        HibernateDetachUtility.nullOutUninitializedFields(l, checkedObjects, depth + 1, serializationType);
                        replacement = new HashSet(l);
                        needToNullOutFields = false;
                    } else if (fieldValue instanceof Collection) {
                        replacement = new ArrayList((Collection)fieldValue);
                    }
                    HibernateDetachUtility.setField(object, field.getName(), replacement);
                    if (needToNullOutFields) {
                        HibernateDetachUtility.nullOutUninitializedFields(replacement, checkedObjects, depth + 1, serializationType);
                    }
                }
            } else if (fieldValue != null && (fieldValue.getClass().getName().contains("org.rhq") || fieldValue instanceof Collection || fieldValue instanceof Object[] || fieldValue instanceof Map)) {
                HibernateDetachUtility.nullOutUninitializedFields(fieldValue, checkedObjects, depth + 1, serializationType);
            }
            if (!accessModifierFlag) continue;
            field.setAccessible(false);
        }
    }

    private static Object replaceObject(Object object) {
        Object replacement = null;
        if (object instanceof HibernateProxy && object.getClass().getName().contains("javassist")) {
            Class<?> assistClass = object.getClass();
            try {
                Method m = assistClass.getMethod("writeReplace", new Class[0]);
                replacement = m.invoke(object, new Object[0]);
                String className = object.getClass().getName();
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to write replace object " + object.getClass()), (Throwable)e);
            }
        }
        return replacement;
    }

    private static void nullOutFieldsByAccessors(Object value, Map<Integer, Object> checkedObjects, int depth, SerializationType serializationType) throws Exception {
        PropertyDescriptor[] pds;
        BeanInfo bi = Introspector.getBeanInfo(value.getClass(), Object.class);
        for (PropertyDescriptor pd : pds = bi.getPropertyDescriptors()) {
            Object propertyValue;
            block8: {
                propertyValue = null;
                try {
                    propertyValue = pd.getReadMethod().invoke(value, new Object[0]);
                }
                catch (Throwable lie) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug((Object)("Couldn't load: " + pd.getName() + " off of " + value.getClass().getSimpleName()), lie);
                }
            }
            if (!Hibernate.isInitialized((Object)propertyValue)) {
                try {
                    Method writeMethod;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Nulling out: " + pd.getName() + " off of " + value.getClass().getSimpleName()));
                    }
                    if ((writeMethod = pd.getWriteMethod()) != null && writeMethod.getAnnotation(XmlTransient.class) == null) {
                        pd.getWriteMethod().invoke(value, new Object[]{null});
                        continue;
                    }
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                catch (Exception lie) {
                    LOG.debug((Object)("Couldn't null out: " + pd.getName() + " off of " + value.getClass().getSimpleName() + " trying field access"), (Throwable)lie);
                    HibernateDetachUtility.nullOutField(value, pd.getName());
                }
                continue;
            }
            if (!(propertyValue instanceof Collection) && (propertyValue == null || !propertyValue.getClass().getName().startsWith("org.rhq.core.domain"))) continue;
            HibernateDetachUtility.nullOutUninitializedFields(propertyValue, checkedObjects, depth + 1, serializationType);
        }
    }

    private static void setField(Object object, String fieldName, Object newValue) {
        try {
            Field f = object.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(object, newValue);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private static void nullOutField(Object value, String fieldName) {
        try {
            Field f = value.getClass().getDeclaredField(fieldName);
            if (f != null) {
                f.setAccessible(true);
                f.set(value, null);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    static {
        int value;
        LOG = LogFactory.getLog(HibernateDetachUtility.class);
        try {
            String str = System.getProperty(DEPTH_ALLOWED_SYSPROP, "50");
            value = Integer.parseInt(str);
        }
        catch (Throwable t) {
            value = 50;
        }
        depthAllowed = value;
    }

    public static enum SerializationType {
        SERIALIZATION,
        JAXB;

    }
}

