/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.attributes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.richfaces.cdk.attributes.Adapters;
import org.richfaces.cdk.attributes.Attribute;
import org.richfaces.cdk.attributes.ContainerType;
import org.richfaces.cdk.attributes.KeyedType;

public class Element
implements KeyedType {
    private String name;
    private Map<String, Attribute> attributes = new TreeMap<String, Attribute>();

    public Element() {
    }

    public Element(String name) {
        this.name = name;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.put(attribute.getName(), attribute);
    }

    @XmlJavaTypeAdapter(value=Adapters.AttributeAdapter.class)
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Attribute> attributes) {
        this.attributes = attributes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Element other = (Element)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @XmlRootElement(name="elements")
    @XmlType(name="ElementsType")
    public static final class Type
    implements ContainerType<Element> {
        private Collection<Element> children = new HashSet<Element>();

        @Override
        @XmlElement(name="element")
        public Collection<Element> getChildren() {
            return this.children;
        }

        @Override
        public void setChildren(Collection<Element> values) {
            this.children = values;
        }
    }
}

