/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.ajax4jsf.builder.generator.AbstractClassStubBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetResourceInterceptor
implements MethodInterceptor {
    private static final Class<?>[] SIGNATURE = new Class[]{String.class};
    private ClassLoader classLoader;
    private List<String> list = new ArrayList<String>();
    private Map<String, Object> resources = new HashMap<String, Object>();
    private Map<Object, String> resourcesInverse = new IdentityHashMap<Object, String>();

    public GetResourceInterceptor(ClassLoader loader) {
        this.classLoader = loader;
    }

    public List<String> getList() {
        return this.list;
    }

    public String getResourceName(Object resource) {
        return this.resourcesInverse.get(resource);
    }

    public void clearList() {
        this.list.clear();
    }

    public Object intercept(Object instance, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if ("getResource".equals(method.getName()) && Arrays.equals(SIGNATURE, method.getParameterTypes())) {
            Class<?> returnType;
            String resourceName = (String)args[0];
            this.list.add(resourceName);
            Object resource = this.resources.get(resourceName);
            if (resource == null && (returnType = method.getReturnType()).isInterface()) {
                Object interfaceStub = AbstractClassStubBuilder.buildInterfaceStub(returnType, this.classLoader);
                this.resources.put(resourceName, interfaceStub);
                this.resourcesInverse.put(interfaceStub, resourceName);
                return interfaceStub;
            }
            return null;
        }
        return methodProxy.invokeSuper(instance, args);
    }
}

