/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.generator;

import java.io.File;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ComponentBaseBean;
import org.ajax4jsf.builder.generator.ClassPatternSet;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.velocity.Template;

public abstract class InnerGenerator {
    private File _destDir = null;
    private String _templateName;
    private JSFGeneratorConfiguration _config;
    private Logger _log;
    protected ClassPatternSet _patterns = new ClassPatternSet();

    public InnerGenerator(JSFGeneratorConfiguration config, Logger log) {
        this._config = config;
        this._log = log;
    }

    public JSFGeneratorConfiguration getConfig() {
        return this._config;
    }

    public void setConfig(JSFGeneratorConfiguration config) {
        this._config = config;
    }

    public File getDestDir() throws GeneratorException {
        File destDir = this._destDir;
        if (null == destDir) {
            destDir = this._config.getDestDir();
        }
        if (destDir == null) {
            throw new GeneratorException("Destination directory not set");
        }
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new GeneratorException("Destination not is directory");
        }
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        return destDir;
    }

    public void setDestDir(File destDir) {
        this._destDir = destDir;
    }

    public String getKey() {
        return this._config.getKey();
    }

    public ClassLoader getClassLoader() {
        return this._config.getClassLoader();
    }

    public String getTemplateName() {
        if (null != this._templateName) {
            return this._templateName;
        }
        return this._config.getTemplatesPath() + "/" + this.getDefaultTemplateName();
    }

    public void setTemplateName(String template) {
        this._templateName = template;
    }

    public Template getTemplate() throws GeneratorException {
        return this._config.getTemplate(this.getTemplateName());
    }

    public abstract void createFiles(BuilderConfig var1) throws GeneratorException;

    protected abstract String getDefaultTemplateName();

    public Logger getLog() {
        return this._log;
    }

    public void info(String arg0) {
        this.getLog().info(arg0);
    }

    public void debug(String arg0) {
        this.getLog().debug(arg0);
    }

    public ClassPatternSet.PatternEntry createExclude() {
        return this._patterns.createExclude();
    }

    public ClassPatternSet.PatternEntry createInclude() {
        return this._patterns.createInclude();
    }

    public void setExcludes(String arg0) {
        this._patterns.setExcludes(arg0);
    }

    public void setIncludes(String arg0) {
        this._patterns.setIncludes(arg0);
    }

    protected boolean isIncludeComponent(ComponentBaseBean component) {
        boolean includeComponent = this._patterns.matchClass(component.getName());
        return includeComponent;
    }
}

