/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.ant;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.ajax4jsf.builder.ant.AntLogger;
import org.ajax4jsf.builder.config.BuilderConfig;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.generator.ComponentGenerator;
import org.ajax4jsf.builder.generator.ComponentTagGenerator;
import org.ajax4jsf.builder.generator.FaceletsTaglibGenerator;
import org.ajax4jsf.builder.generator.FacesConfigGenerator;
import org.ajax4jsf.builder.generator.GeneratorException;
import org.ajax4jsf.builder.generator.InnerGenerator;
import org.ajax4jsf.builder.generator.JSFGeneratorConfiguration;
import org.ajax4jsf.builder.generator.ListenerGenerator;
import org.ajax4jsf.builder.generator.RendererGenerator;
import org.ajax4jsf.builder.generator.TagHandlerGenerator;
import org.ajax4jsf.builder.generator.TaglibGenerator;
import org.ajax4jsf.builder.velocity.BuilderContext;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.Path;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class JSFGeneratorTask
extends Task
implements JSFGeneratorConfiguration {
    private FileList _configs;
    private File configFile;
    private File destDir;
    private File templates;
    private Path _classpath;
    private BuilderConfig _config = null;
    private List<InnerGenerator> _inners = new ArrayList<InnerGenerator>();
    private String key;
    private String templatesPath = "META-INF/templates";
    private static final String VELOCITY_PROPERTIES = "velocity.properties";
    private VelocityEngine engine;
    private Map<String, Template> _templates = new HashMap<String, Template>();

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public FileList createConfigs() {
        this._configs = new FileList();
        return this._configs;
    }

    public File getDestDir() {
        return this.destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public File getTemplates() {
        return this.templates;
    }

    public void setTemplates(File templates) {
        this.templates = templates;
    }

    public Path getClasspath() {
        return this._classpath;
    }

    public void setClasspath(Path classpath) {
        if (null == this._classpath) {
            this._classpath = classpath;
        } else {
            this._classpath.add(classpath);
        }
    }

    public Path createClasspath() {
        Path classpath = new Path(this.getProject());
        if (null == this._classpath) {
            this._classpath = classpath;
        } else {
            this._classpath.add(classpath);
        }
        return classpath;
    }

    public void setClasspathRef(Ant.Reference ref) {
        Object refObj = ref.getReferencedObject();
        if (refObj instanceof Path) {
            this.setClasspath((Path)refObj);
        }
    }

    public void init() throws BuildException {
        super.init();
        Properties velocityProperties = new Properties();
        try {
            InputStream streamVelosityProperties = JSFGeneratorTask.class.getResourceAsStream(VELOCITY_PROPERTIES);
            velocityProperties.load(streamVelosityProperties);
            this.engine = new VelocityEngine();
            this.engine.init(velocityProperties);
        }
        catch (Exception e) {
            throw new BuildException("Error init velocity engine", (Throwable)e);
        }
    }

    public Template getTemplate(String name) throws GeneratorException {
        Template template = this._templates.get(name);
        if (null == template) {
            try {
                template = this.engine.getTemplate(name);
            }
            catch (ResourceNotFoundException e) {
                throw new GeneratorException(e.getLocalizedMessage());
            }
            catch (ParseErrorException e) {
                throw new GeneratorException(e.getLocalizedMessage());
            }
            catch (Exception e) {
                throw new GeneratorException(e.getLocalizedMessage());
            }
            this._templates.put(name, template);
        }
        return template;
    }

    public void execute() throws BuildException {
        BuilderConfig config = this.getBuilderConfig();
        for (InnerGenerator generator : this._inners) {
            this.getProject().log("Build files for subtask " + generator.getClass().getSimpleName());
            try {
                generator.createFiles(config);
            }
            catch (Exception e) {
                this.getProject().log("Error for buid files by builder " + generator.getClass().getSimpleName(), 0);
                e.printStackTrace();
                throw new BuildException("Error for buid files by builder " + generator.getClass().getSimpleName(), (Throwable)e);
            }
        }
    }

    private BuilderConfig getBuilderConfig() throws BuildException {
        if (null == this._config) {
            if (this.getConfigFile() == null && this.getConfigs() == null) {
                throw new BuildException("Config file name not set");
            }
            try {
                BuilderContext.init(this.getTemplates());
            }
            catch (GeneratorException e1) {
                throw new BuildException((Throwable)e1);
            }
            try {
                this._config = new BuilderConfig(this.getClassLoader(), new AntLogger(this));
                if (null != this.getConfigFile()) {
                    this._config.parseConfig(this.getConfigFile());
                }
                if (null != this.getConfigs()) {
                    String[] files = this.getConfigs().getFiles(this.getProject());
                    for (int i = 0; i < files.length; ++i) {
                        String file = files[i];
                        this._config.parseConfig(new File(this.getConfigs().getDir(this.getProject()), file));
                    }
                }
                this._config.checkComponentProperties();
            }
            catch (ParsingException e) {
                e.printStackTrace();
                throw new BuildException("Error building ", (Throwable)e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("Error building ", (Throwable)e);
            }
        }
        return this._config;
    }

    public ClassLoader getClassLoader() {
        return this.getProject().createClassLoader(this.getClasspath());
    }

    public ComponentGenerator createComponents() {
        ComponentGenerator generator = new ComponentGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public FacesConfigGenerator createFacesconfig() {
        FacesConfigGenerator generator = new FacesConfigGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public RendererGenerator createRenderers() {
        RendererGenerator generator = new RendererGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public ComponentTagGenerator createTags() {
        ComponentTagGenerator generator = new ComponentTagGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public TaglibGenerator createTaglib() {
        TaglibGenerator generator = new TaglibGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public FaceletsTaglibGenerator createFaceletsTaglib() {
        FaceletsTaglibGenerator generator = new FaceletsTaglibGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public TagHandlerGenerator createTagHandler() {
        TagHandlerGenerator generator = new TagHandlerGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    public ListenerGenerator createListenerGenerator() {
        ListenerGenerator generator = new ListenerGenerator(this, new AntLogger(this));
        this._inners.add(generator);
        return generator;
    }

    private FileList getConfigs() {
        return this._configs;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        if (key != null && key.length() == 0) {
            this.key = null;
        }
    }

    public String getTemplatesPath() {
        return this.templatesPath;
    }

    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }
}

