/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ajax4jsf.builder.config.ComponentBaseBean;
import org.ajax4jsf.builder.config.ComponentBean;
import org.ajax4jsf.builder.config.ConverterBean;
import org.ajax4jsf.builder.config.EventBean;
import org.ajax4jsf.builder.config.FunctionBean;
import org.ajax4jsf.builder.config.JsfBean;
import org.ajax4jsf.builder.config.ListenerBean;
import org.ajax4jsf.builder.config.LoaderHolder;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.config.RendererBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.config.TagHandlerBean;
import org.ajax4jsf.builder.config.TagTestClassHolder;
import org.ajax4jsf.builder.config.TestClassHolder;
import org.ajax4jsf.builder.config.ValidatorBean;
import org.ajax4jsf.builder.generator.Logger;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rules;
import org.apache.tools.ant.BuildException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderConfig
implements LoaderHolder {
    public static final String COMPONENT_SCHEMA_BASE = "/META-INF/schema/";
    public static final String ENTITIES_FOLDER = "entities";
    private static final String COMPONENT_CONFIG_DTD_URI = "/META-INF/schema/component-config.dtd";
    private static final String GENERATOR_CONFIG_ROOT_ELEMENT = "components";
    private static final String GENERATOR_CONFIG_PUBLIC_ID = "-//AJAX4JSF//CDK Generator config/EN";
    private List<ComponentBean> components = new ArrayList<ComponentBean>();
    private List<ValidatorBean> validators = new ArrayList<ValidatorBean>();
    private List<ConverterBean> converters = new ArrayList<ConverterBean>();
    private List<RendererBean> renderers = new ArrayList<RendererBean>();
    private List<ListenerBean> listeners = new ArrayList<ListenerBean>();
    private List<FunctionBean> functions = new ArrayList<FunctionBean>();
    private ClassLoader _loader;
    private Logger _log;

    public BuilderConfig(ClassLoader loader, Logger log) {
        this._loader = loader;
        this._log = log;
    }

    public void parseConfig(File configFile) throws ParsingException {
        this.getLog().info(" Parse config file " + configFile.toString());
        Digester digester = new Digester();
        digester.setRules((Rules)new ExtendedBaseRules());
        digester.setValidating(false);
        digester.setNamespaceAware(false);
        this.getLog().debug("Register config DTD as URI /META-INF/schema/component-config.dtd");
        digester.register(GENERATOR_CONFIG_PUBLIC_ID, COMPONENT_CONFIG_DTD_URI);
        digester.setEntityResolver((EntityResolver)new EntityResolver2(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                BuilderConfig.this.getLog().debug("Request for entity with systemId " + systemId + " and publicId " + publicId);
                if (BuilderConfig.GENERATOR_CONFIG_PUBLIC_ID.equals(publicId)) {
                    return this.getDTDSource();
                }
                if (null != publicId && null != systemId && systemId.contains(BuilderConfig.ENTITIES_FOLDER)) {
                    int base = systemId.indexOf(BuilderConfig.ENTITIES_FOLDER);
                    String entity = BuilderConfig.COMPONENT_SCHEMA_BASE + systemId.substring(base);
                    BuilderConfig.this.getLog().debug("attempt to load entity from classpath " + entity);
                    InputStream entityStream = BuilderConfig.class.getResourceAsStream(entity);
                    if (null != entityStream) {
                        return new InputSource(entityStream);
                    }
                }
                return null;
            }

            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                BuilderConfig.this.getLog().debug("Request for ExternalSubset with name " + name + " and baseURI " + baseURI);
                if (BuilderConfig.GENERATOR_CONFIG_ROOT_ELEMENT.equals(name)) {
                    return this.getDTDSource();
                }
                return null;
            }

            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                BuilderConfig.this.getLog().debug("Request for extended entity with systemId " + systemId + " and publicId " + publicId);
                BuilderConfig.this.getLog().debug("additional parameters with name " + name + " and baseURI " + baseURI);
                if ("[dtd]".equals(name) && BuilderConfig.GENERATOR_CONFIG_PUBLIC_ID.equals(publicId)) {
                    return this.getDTDSource();
                }
                if (null == name || !name.startsWith("[") && !name.startsWith("&")) {
                    return this.resolveEntity(publicId, systemId);
                }
                return null;
            }

            private InputSource getDTDSource() {
                return new InputSource(BuilderConfig.class.getResourceAsStream(BuilderConfig.COMPONENT_CONFIG_DTD_URI));
            }
        });
        String path = "components/component";
        digester.addObjectCreate(path, ComponentBean.class);
        digester.addBeanPropertySetter(path + "/name");
        digester.addBeanPropertySetter(path + "/family");
        digester.addBeanPropertySetter(path + "/classname");
        digester.addBeanPropertySetter(path + "/superclass");
        digester.addBeanPropertySetter(path + "/description");
        digester.addBeanPropertySetter(path + "/displayname");
        digester.addBeanPropertySetter(path + "/icon");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addComponent");
        path = "components/renderer";
        digester.addObjectCreate(path, RendererBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addRenderer");
        path = "components/component/renderer";
        digester.addObjectCreate(path, RendererBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setRenderer");
        path = "components/component/facet";
        digester.addObjectCreate(path, JsfBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addFacet");
        path = "components/component/event";
        digester.addObjectCreate(path, EventBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addEvent");
        path = "components/validator";
        digester.addObjectCreate(path, ValidatorBean.class);
        digester.addBeanPropertySetter(path + "/id");
        digester.addBeanPropertySetter(path + "/classname");
        digester.addBeanPropertySetter(path + "/superclass");
        digester.addBeanPropertySetter(path + "/description");
        digester.addBeanPropertySetter(path + "/displayname");
        digester.addBeanPropertySetter(path + "/icon");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addValidator");
        path = "components/validator/property";
        digester.addObjectCreate(path, PropertyBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addProperty");
        path = "components/converter";
        digester.addObjectCreate(path, ConverterBean.class);
        digester.addBeanPropertySetter(path + "/id");
        digester.addBeanPropertySetter(path + "/classname");
        digester.addBeanPropertySetter(path + "/superclass");
        digester.addBeanPropertySetter(path + "/description");
        digester.addBeanPropertySetter(path + "/displayname");
        digester.addBeanPropertySetter(path + "/icon");
        digester.addBeanPropertySetter(path + "/forclass");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addConverter");
        path = "components/function";
        digester.addObjectCreate(path, FunctionBean.class);
        digester.addBeanPropertySetter(path + "/name");
        digester.addBeanPropertySetter(path + "/description");
        digester.addBeanPropertySetter(path + "/method");
        digester.addSetNext(path, "addFunction");
        path = "components/component/tag";
        digester.addObjectCreate(path, TagBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTag");
        path = "components/validator/tag";
        digester.addObjectCreate(path, TagBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTag");
        path = "components/converter/tag";
        digester.addObjectCreate(path, TagBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTag");
        path = "components/component/tag/test";
        digester.addObjectCreate(path, TagTestClassHolder.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTest");
        path = "components/component/test";
        digester.addObjectCreate(path, TestClassHolder.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTest");
        path = "components/component/taghandler";
        digester.addObjectCreate(path, TagHandlerBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTaghandler");
        path = "components/component/property";
        digester.addObjectCreate(path, PropertyBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addProperty");
        path = "components/converter/property";
        digester.addObjectCreate(path, PropertyBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addProperty");
        path = "*/properties/property";
        digester.addObjectCreate(path, PropertyBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addProperty");
        path = "components/listener";
        digester.addObjectCreate(path, ListenerBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addListener");
        path = "components/listener/tag";
        digester.addObjectCreate(path, TagBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTag");
        path = "components/listener/taghandler";
        digester.addObjectCreate(path, TagHandlerBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "setTaghandler");
        path = "components/listener/property";
        digester.addObjectCreate(path, PropertyBean.class);
        digester.addBeanPropertySetter(path + "/?");
        digester.addSetProperties(path);
        digester.addSetNext(path, "addProperty");
        digester.push((Object)this);
        try {
            digester.parse(configFile.toString());
        }
        catch (IOException e) {
            throw new ParsingException("I/O error on parsing config file ", e);
        }
        catch (SAXException e) {
            throw new ParsingException("SAX Parsing error in config file ", e);
        }
    }

    public void checkComponentProperties() throws ParsingException {
        for (ListenerBean listenerBean : this.getListeners()) {
            try {
                Class<?> listenerClass = Class.forName(listenerBean.getComponentclass(), false, this.getLoader());
                for (ComponentBean bean : this.getComponents()) {
                    Map<String, PropertyDescriptor> map;
                    PropertyDescriptor propertyDescriptor;
                    Class<?> componentSClass;
                    if (bean.getSuperclass() == null || !listenerClass.isAssignableFrom(componentSClass = Class.forName(bean.getSuperclass(), false, this.getLoader()))) continue;
                    PropertyBean listenerProperty = bean.getProperty(listenerBean.getName());
                    if (null == listenerProperty) {
                        listenerProperty = new PropertyBean();
                        listenerProperty.setName(listenerBean.getName());
                        bean.addProperty(listenerProperty);
                        listenerProperty.setClassname("javax.el.MethodExpression");
                    }
                    if ((propertyDescriptor = (map = this.getPropertyDescriptors(componentSClass)).get(listenerBean.getName())) != null) {
                        String componentPropertyName = propertyDescriptor.getPropertyType().getName();
                        if (!componentPropertyName.equals(listenerProperty.getClassname())) {
                            this._log.error(String.format("Overriding property type %s with %s for %s.%s", listenerProperty.getClassname(), componentPropertyName, bean.getClassname(), listenerBean.getName()));
                        }
                        listenerProperty.setClassname(componentPropertyName);
                    }
                    listenerProperty.setEl(true);
                    listenerProperty.setElonly(true);
                    listenerProperty.setAttachedstate(true);
                    listenerProperty.setMethodargs(listenerBean.getEventclass());
                    listenerBean.addSuitableComponent(bean);
                }
            }
            catch (ClassNotFoundException e) {
                throw new BuildException((Throwable)e);
            }
            listenerBean.checkProperties();
        }
        for (ComponentBaseBean componentBaseBean : this.getComponents()) {
            componentBaseBean.checkProperties();
        }
        for (ComponentBaseBean componentBaseBean : this.getValidators()) {
            componentBaseBean.checkProperties();
        }
        for (ComponentBaseBean componentBaseBean : this.getConverters()) {
            componentBaseBean.checkProperties();
        }
    }

    private Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> clazz) {
        PropertyDescriptor[] descriptors;
        Class<?>[] interfaces;
        if (clazz.equals(Object.class)) {
            return Collections.emptyMap();
        }
        TreeMap<String, PropertyDescriptor> m = new TreeMap<String, PropertyDescriptor>();
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            m.putAll(this.getPropertyDescriptors(superclass));
        }
        if ((interfaces = clazz.getInterfaces()) != null) {
            for (Class<?> intrfc : interfaces) {
                m.putAll(this.getPropertyDescriptors(intrfc));
            }
        }
        for (PropertyDescriptor propertyDescriptor : descriptors = PropertyUtils.getPropertyDescriptors(clazz)) {
            m.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return m;
    }

    @Override
    public ClassLoader getLoader() {
        return this._loader;
    }

    @Override
    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    @Override
    public Logger getLog() {
        return this._log;
    }

    public void addComponent(ComponentBean component) {
        this.components.add(component);
        component.setParent(this);
    }

    public void addValidator(ValidatorBean validator) {
        this.validators.add(validator);
        validator.setParent(this);
    }

    public void addConverter(ConverterBean converter) {
        this.converters.add(converter);
        converter.setParent(this);
    }

    public void addRenderer(RendererBean renderer) {
        this.renderers.add(renderer);
        renderer.setParent(this);
    }

    public void addListener(ListenerBean listener) {
        this.listeners.add(listener);
        listener.setParent(this);
    }

    public void addFunction(FunctionBean function) {
        this.functions.add(function);
        function.setParent(this);
    }

    public void clear() {
        this.components.clear();
        this.renderers.clear();
    }

    public boolean contains(Object o) {
        return this.components.contains(o);
    }

    public ComponentBaseBean get(int index) {
        return this.components.get(index);
    }

    public int indexOf(ComponentBaseBean o) {
        return this.components.indexOf(o);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public List<ComponentBean> getComponents() {
        return this.components;
    }

    public List<ConverterBean> getConverters() {
        return this.converters;
    }

    public List<ValidatorBean> getValidators() {
        return this.validators;
    }

    public List<ListenerBean> getListeners() {
        return this.listeners;
    }

    public List<RendererBean> getRenderers() {
        return this.renderers;
    }

    public List<FunctionBean> getFunctions() {
        return this.functions;
    }

    public ComponentBaseBean remove(int index) {
        return this.components.remove(index);
    }

    public boolean remove(ComponentBaseBean o) {
        return this.components.remove(o);
    }

    public int size() {
        return this.components.size();
    }
}

