/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.builder.config.ClassVisitor;
import org.ajax4jsf.builder.config.ClassWalkingLogic;
import org.ajax4jsf.builder.config.JsfBean;
import org.ajax4jsf.builder.config.ParsingException;
import org.ajax4jsf.builder.config.PropertyBean;
import org.ajax4jsf.builder.config.TagBean;
import org.ajax4jsf.builder.config.TagHandlerBean;
import org.apache.commons.beanutils.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBaseBean
extends JsfBean {
    private static final String[] ignorableComponentProperties = new String[]{"class", "attributes", "childCount", "children", "facets", "facetsAndChildren", "family", "parent", "rendererType", "rendersChildren", "submittedValue", "transient"};
    private static final String[] enabledTagProperties = new String[]{"binding"};
    private static final String[] attachedStateProperties = new String[]{"javax.faces.component.StateHolder", "java.util.List", "javax.faces.el.MethodBinding", "javax.faces.el.ValueBinding", "javax.el.MethodExpression", "javax.el.ValueExpression", "javax.faces.convert.Converter"};
    private TagBean _tag;
    private TagHandlerBean _taghandler;
    private Map<String, PropertyBean> properties = new TreeMap<String, PropertyBean>();
    private boolean generate = true;

    public TagBean getTag() {
        return this._tag;
    }

    public void setTag(TagBean tag) {
        this._tag = tag;
        tag.setParent(this);
    }

    public boolean isGenerate() {
        return this.generate;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public TagHandlerBean getTaghandler() {
        return this._taghandler;
    }

    public void setTaghandler(TagHandlerBean tagSupport) {
        this._taghandler = tagSupport;
    }

    public Collection<PropertyBean> getProperties() {
        return this.properties.values();
    }

    public boolean containProperty(String name) {
        return this.properties.containsKey(name);
    }

    public PropertyBean getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(PropertyBean property) {
        this.properties.put(property.getName(), property);
        property.setParent(this);
    }

    public void checkProperties() throws ParsingException {
        Class<?> superClass;
        try {
            this.getLog().debug("Parse properties for Component " + this.getName() + " with superclass " + this.getSuperclass());
            if (this.getSuperclass() != null) {
                superClass = this.getLoader().loadClass(this.getSuperclass());
                new ClassWalkingLogic(superClass).walk(new ClassVisitor(){

                    @Override
                    public void visit(Class<?> clazz) {
                        ComponentBaseBean.this.checkPropertiesForClass(clazz);
                    }
                });
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for component " + this.getName(), e);
        }
        if (null != this.getTag()) {
            try {
                superClass = this.getLoader().loadClass(this.getTag().getSuperclass());
                PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(superClass);
                for (int i = 0; i < properties.length; ++i) {
                    PropertyDescriptor descriptor = properties[i];
                    Method writeMethod = descriptor.getWriteMethod();
                    if (this.containProperty(descriptor.getName())) {
                        if (null == writeMethod || Modifier.isAbstract(writeMethod.getModifiers()) || !Modifier.isPublic(writeMethod.getModifiers())) continue;
                        this.properties.get(descriptor.getName()).setExistintag(true);
                        continue;
                    }
                    if (null == writeMethod || !Modifier.isPublic(writeMethod.getModifiers()) || !Arrays.asList(enabledTagProperties).contains(descriptor.getName())) continue;
                    Class<?> type = descriptor.getPropertyType();
                    this.getLog().debug("Register tag property  " + descriptor.getName() + " with type name " + type.getCanonicalName());
                    PropertyBean property = new PropertyBean();
                    property.setName(descriptor.getName());
                    property.setDescription(descriptor.getShortDescription());
                    property.setDisplayname(descriptor.getDisplayName());
                    property.setClassname(descriptor.getPropertyType().getCanonicalName());
                    property.setExist(true);
                    if (!Modifier.isAbstract(writeMethod.getModifiers())) {
                        property.setExistintag(true);
                    }
                    this.addProperty(property);
                }
            }
            catch (ClassNotFoundException e) {
                this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            }
        }
    }

    private void checkPropertiesForClass(Class<?> superClass) {
        this.getLog().debug("Check properties for class " + superClass.getName());
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors(superClass);
        for (int i = 0; i < properties.length; ++i) {
            PropertyBean property;
            PropertyDescriptor descriptor = properties[i];
            if (!this.containProperty(descriptor.getName())) {
                if (this.isIgnorableProperty(superClass, descriptor.getName())) continue;
                Class<?> type = descriptor.getPropertyType();
                this.getLog().debug("Register property  " + descriptor.getName() + " with type name " + type.getCanonicalName());
                property = new PropertyBean();
                property.setName(descriptor.getName());
                property.setDescription(descriptor.getShortDescription());
                property.setDisplayname(descriptor.getDisplayName());
                property.setClassname(descriptor.getPropertyType().getCanonicalName());
                property.setExist(true);
                this.addProperty(property);
            } else {
                this.getLog().debug("Check  property  " + descriptor.getName());
                property = this.properties.get(descriptor.getName());
                if (property.getClassname() == null) {
                    property.setClassname(descriptor.getPropertyType().getCanonicalName());
                } else if (!property.getClassname().equals(descriptor.getPropertyType().getCanonicalName())) {
                    String message = "Class " + property.getClassname() + " for property " + property.getName() + " not equals with real bean property type: " + descriptor.getPropertyType().getCanonicalName();
                    this.getLog().error(message);
                }
                if (property.getDescription() == null) {
                    property.setDescription(descriptor.getShortDescription());
                }
                if (property.getDisplayname() == null) {
                    property.setDisplayname(descriptor.getDisplayName());
                }
                property.setExist(true);
            }
            Method getter = descriptor.getReadMethod();
            Method setter = descriptor.getWriteMethod();
            if (null != setter && null != getter && (Modifier.isAbstract(getter.getModifiers()) && Modifier.isAbstract(setter.getModifiers()) || superClass.isInterface())) {
                this.getLog().debug("Detect as abstract property  " + descriptor.getName());
                property.setExist(false);
            }
            if (null == setter || !Modifier.isPublic(setter.getModifiers())) {
                this.getLog().debug("Detect as hidden property  " + descriptor.getName());
                property.setHidden(true);
            }
            if (this.isAttachedProperty(property)) {
                property.setAttachedstate(true);
            }
            if (!property.isInstanceof("javax.faces.el.MethodBinding") && !property.isInstanceof("javax.faces.el.ValueBinding")) continue;
            property.setElonly(true);
        }
    }

    private boolean isIgnorableProperty(Class<?> base, String name) {
        return Arrays.asList(ignorableComponentProperties).contains(name);
    }

    private boolean isAttachedProperty(PropertyBean prop) {
        for (int i = 0; i < attachedStateProperties.length; ++i) {
            String clazz = attachedStateProperties[i];
            if (!prop.isInstanceof(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isStateHolderRequired() {
        this.getLog().info("isStateHolderRequired");
        for (PropertyBean propertyBean : this.getProperties()) {
            this.getLog().info("Property " + propertyBean.getName() + "/" + propertyBean.isTransient());
            if (propertyBean.isTransient()) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperclassImplementsStateHolder() {
        try {
            Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
            return StateHolder.class.isAssignableFrom(superClass);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            return false;
        }
    }

    public boolean isSuperSaveStateMethodExists() {
        try {
            Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
            Class[] signature = new Class[]{FacesContext.class};
            try {
                Method m = superClass.getMethod("saveState", signature);
                return !Modifier.isAbstract(m.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            return false;
        }
    }

    public boolean isSuperRestoreStateMethodExists() {
        try {
            Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
            Class[] signature = new Class[]{FacesContext.class, Object.class};
            try {
                Method m = superClass.getMethod("restoreState", signature);
                return !Modifier.isAbstract(m.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            return false;
        }
    }

    public boolean isSuperIsTransientMethodExists() {
        try {
            Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
            Class[] signature = new Class[]{};
            try {
                Method m = superClass.getMethod("isTransient", signature);
                return !Modifier.isAbstract(m.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            return false;
        }
    }

    public boolean isSuperSetTransientMethodExists() {
        try {
            Class<?> superClass = this.getLoader().loadClass(this.getSuperclass());
            Class[] signature = new Class[]{Boolean.TYPE};
            try {
                Method m = superClass.getMethod("setTransient", signature);
                return !Modifier.isAbstract(m.getModifiers());
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error("superclass not found for tag " + this.getTag().getName(), e);
            return false;
        }
    }
}

