/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.builder.config;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.ajax4jsf.builder.config.JsfBean;

public class PropertyBean
extends JsfBean {
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");
    private static Map<String, String> defaults = new HashMap<String, String>();
    private boolean _el = true;
    private boolean _elonly = false;
    private boolean _hidden = false;
    private boolean _exist = false;
    private boolean _existintag = false;
    private boolean _raw = false;
    private String _defaultvalue = null;
    private boolean _transient = false;
    private boolean _attachedstate = false;
    private String _alias = null;
    private String _methodargs = null;
    private String _returntype = null;
    private boolean _required = false;

    public boolean isEl() {
        return this._el;
    }

    public void setEl(boolean el) {
        this._el = el;
    }

    public boolean isElonly() {
        return this._elonly;
    }

    public void setElonly(boolean elOnly) {
        this._elonly = elOnly;
    }

    public boolean isExist() {
        return this._exist;
    }

    public void setExist(boolean exist) {
        this._exist = exist;
    }

    public boolean isExistintag() {
        return this._existintag;
    }

    public void setExistintag(boolean existInEl) {
        this._existintag = existInEl;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
        if (hidden) {
            this._existintag = true;
        }
    }

    public void setDisabled(boolean disabled) {
        if (disabled) {
            this.setExist(true);
            this.setHidden(true);
        }
    }

    public boolean isRaw() {
        return this._raw;
    }

    public void setRaw(boolean raw) {
        this._raw = raw;
    }

    public boolean isAttachedstate() {
        return this._attachedstate;
    }

    public void setAttachedstate(boolean attachedState) {
        this._attachedstate = attachedState;
    }

    public String getMethodargs() {
        return this._methodargs;
    }

    public void setMethodargs(String methodargs) {
        this._methodargs = methodargs;
    }

    public String getMethodArgsClasses() {
        if (null != this._methodargs) {
            StringBuffer result = new StringBuffer();
            String[] classes = SEPARATOR_PATTERN.split(this._methodargs.trim());
            for (int i = 0; i < classes.length; ++i) {
                String argumentClass = classes[i];
                if (argumentClass.length() != 0) {
                    if (i != 0) {
                        result.append(',');
                    }
                } else {
                    if (classes.length == 1) break;
                    throw new IllegalArgumentException("Error parsing methodargs: " + this._methodargs);
                }
                result.append(argumentClass).append(".class");
            }
            return result.toString();
        }
        return null;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean transient1) {
        this._transient = transient1;
    }

    public boolean isRequired() {
        return this._required;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public String getAlias() {
        return this._alias;
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public String getGetterName() {
        return this.getGetterPrefix() + this.upperFirstChar(this.getName());
    }

    public String getSetterName() {
        return "set" + this.upperFirstChar(this.getName());
    }

    public String getGetterPrefix() {
        return "boolean".equals(this.getClassname()) ? "is" : "get";
    }

    public String getSimpleClassName() {
        if (null != this.getClassname()) {
            return super.getSimpleClassName();
        }
        return Void.TYPE.getName();
    }

    public void setDefaultvalue(String defaultValue) {
        this._defaultvalue = defaultValue;
    }

    public String getDefaultvalue() {
        if (null != this._defaultvalue) {
            return this._defaultvalue;
        }
        if (defaults.containsKey(this.getClassname())) {
            return defaults.get(this.getClassname());
        }
        return "null";
    }

    public String getReturntype() {
        if (null != this._returntype) {
            return this._returntype;
        }
        return Void.TYPE.getName();
    }

    public void setReturntype(String _returntype) {
        this._returntype = _returntype;
    }

    public boolean isSimpleType() {
        return defaults.containsKey(this.getClassname());
    }

    public String getBoxingClass() {
        if (this.isSimpleType()) {
            String name = this.upperFirstChar(this.getClassname());
            if ("Int".equals(name)) {
                name = "Integer";
            } else if ("Char".equals(name)) {
                name = "Character";
            }
            return name;
        }
        return null;
    }

    static {
        defaults.put(Boolean.TYPE.getName(), "false");
        defaults.put(Byte.TYPE.getName(), "Byte.MIN_VALUE");
        defaults.put(Character.TYPE.getName(), "Character.MIN_VALUE");
        defaults.put(Integer.TYPE.getName(), "Integer.MIN_VALUE");
        defaults.put(Long.TYPE.getName(), "Long.MIN_VALUE");
        defaults.put(Float.TYPE.getName(), "Float.MIN_VALUE");
        defaults.put(Double.TYPE.getName(), "Double.MIN_VALUE");
        defaults.put(Short.TYPE.getName(), "Short.MIN_VALUE");
    }
}

