/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements;

import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.DeclarationElement;
import org.ajax4jsf.templatecompiler.elements.TemplateElement;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.Node;

public class RootElement
extends TemplateElementBase {
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/ComponentTemplate.vm";
    private static final String ENCODE_BEGIN_TEMPLATE = "META-INF/templates/templatecompiler/EncodeBegin.vm";
    private static final String ENCODE_END_TEMPLATE = "META-INF/templates/templatecompiler/EncodeEnd.vm";
    private static final String ENCODE_CHILDREN_TEMPLATE = "META-INF/templates/templatecompiler/EncodeChildren.vm";
    private static final String regexComponent = "(.*)VCPBODY(.*)VCPBODY(.*)";
    private static final Pattern patternComponent = Pattern.compile("(.*)VCPBODY(.*)VCPBODY(.*)", 33);

    public RootElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
    }

    public String getBeginElement() throws CompilationException {
        VelocityContext context = new VelocityContext();
        context.put("component", (Object)this.getComponentBean());
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    public String toCode() throws CompilationException {
        String endElement;
        VelocityContext context = new VelocityContext();
        context.put("component", (Object)this.getComponentBean());
        StringBuffer code = new StringBuffer();
        String beginElement = this.getBeginElement();
        if (null != beginElement) {
            code.append(beginElement);
            code.append("\n");
        }
        StringBuffer declarationsCode = new StringBuffer();
        StringBuffer methodCode = new StringBuffer();
        ListIterator iter = this.getSubElements().listIterator();
        while (iter.hasNext()) {
            TemplateElement element = (TemplateElement)iter.next();
            String toCode = element.toCode();
            if (element instanceof DeclarationElement) {
                declarationsCode.append(toCode);
                continue;
            }
            methodCode.append(toCode);
        }
        if (methodCode.length() > 0) {
            Matcher matcher = patternComponent.matcher(methodCode);
            if (matcher.find()) {
                String strEncodeEnd;
                String strEncodeChildren;
                String strEncodeBegin = matcher.group(1);
                if (strEncodeBegin.trim().length() > 0) {
                    context.put("body", (Object)strEncodeBegin);
                    code.append(this.getComponentBean().processTemplate(this.getEncodeBeginTemplateName(), context));
                }
                if ((strEncodeChildren = matcher.group(2)).trim().length() > 0) {
                    context.put("body", (Object)strEncodeChildren);
                    code.append(this.getComponentBean().processTemplate(this.getEncodeChildrenTemplateName(), context));
                }
                if ((strEncodeEnd = matcher.group(3)).trim().length() > 0) {
                    context.put("body", (Object)strEncodeEnd);
                    code.append(this.getComponentBean().processTemplate(this.getEncodeEndTemplateName(), context));
                }
            } else {
                context.put("body", (Object)methodCode.toString());
                code.append(this.getComponentBean().processTemplate(this.getEncodeEndTemplateName(), context));
            }
        }
        if (declarationsCode.length() > 0) {
            code.append(declarationsCode);
        }
        if ((endElement = this.getEndElement()) != null) {
            code.append(endElement);
            code.append("\n");
        }
        return code.toString();
    }

    protected String getEncodeBeginTemplateName() {
        return ENCODE_BEGIN_TEMPLATE;
    }

    protected String getEncodeEndTemplateName() {
        return ENCODE_END_TEMPLATE;
    }

    protected String getEncodeChildrenTemplateName() {
        return ENCODE_CHILDREN_TEMPLATE;
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() throws CompilationException {
        return "\n}";
    }
}

