/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.std;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.el.ELParser;
import org.ajax4jsf.templatecompiler.elements.NameValuePair;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.ajax4jsf.templatecompiler.elements.std.ScriptObjectTemplateElement;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ScriptOptionTemplateElement
extends TemplateElementBase {
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/scriptOption.vm";
    private List<NameValuePair> values = new ArrayList<NameValuePair>();
    private String defaultValue;
    private String variables = null;
    private String attributes = null;
    private String name = null;
    private String value = null;
    private String wrapperName;

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static String getWrapperName(String wrapper) {
        String result = "DEFAULT";
        if (!ScriptOptionTemplateElement.isEmpty(wrapper)) {
            result = wrapper.replaceAll("(\\p{Upper})", "_$1").toUpperCase(Locale.US);
        }
        return result;
    }

    private void initializeSettings(Node element) {
        Node defaultValueNode;
        Node valueNode;
        Node nameNode;
        Node attributesNode;
        NamedNodeMap nnm = element.getAttributes();
        Node variablesNode = nnm.getNamedItem("variables");
        if (variablesNode != null) {
            this.variables = variablesNode.getNodeValue();
        }
        if ((attributesNode = nnm.getNamedItem("attributes")) != null) {
            this.attributes = attributesNode.getNodeValue();
        }
        if ((nameNode = nnm.getNamedItem("name")) != null) {
            this.name = nameNode.getNodeValue();
        }
        if ((valueNode = nnm.getNamedItem("value")) != null) {
            this.value = valueNode.getNodeValue();
        }
        if ((defaultValueNode = nnm.getNamedItem("defaultValue")) != null) {
            this.defaultValue = defaultValueNode.getNodeValue();
        }
        Node wrapperNode = nnm.getNamedItem("wrapper");
        String wrapperNodeValue = null;
        if (wrapperNode != null) {
            wrapperNodeValue = wrapperNode.getNodeValue();
        }
        this.wrapperName = ScriptOptionTemplateElement.getWrapperName(wrapperNodeValue);
    }

    private void checkSettings() {
        if (!ScriptOptionTemplateElement.isEmpty(this.attributes) || !ScriptOptionTemplateElement.isEmpty(this.variables)) {
            if (!ScriptOptionTemplateElement.isEmpty(this.name) || !ScriptOptionTemplateElement.isEmpty(this.value)) {
                throw new RuntimeException("c:scriptOption tag misconfiguration: use either 'attributes'/'variables' or 'name' and 'value'!");
            }
        } else if (ScriptOptionTemplateElement.isEmpty(this.name) || ScriptOptionTemplateElement.isEmpty(this.value)) {
            throw new RuntimeException("c:scriptOption tag misconfiguration: 'name' and 'value' should be both set!");
        }
    }

    private void addELValues(String namesList, String elFormat, CompilationContext componentBean) {
        if (!ScriptOptionTemplateElement.isEmpty(namesList)) {
            String[] attributesSet;
            for (String attribute : attributesSet = namesList.split(",")) {
                String trimmedAttribute = attribute.trim();
                if (trimmedAttribute.length() == 0) continue;
                String elExpression = String.format(elFormat, trimmedAttribute);
                this.values.add(new NameValuePair(trimmedAttribute, ELParser.compileEL(elExpression, componentBean)));
            }
        }
    }

    public ScriptOptionTemplateElement(Node element, CompilationContext componentBean) {
        super(element, componentBean);
        componentBean.addToImport("org.ajax4jsf.renderkit.RendererUtils.ScriptHashVariableWrapper");
        this.initializeSettings(element);
        this.checkSettings();
        this.addELValues(this.attributes, "#{component.attributes['%s']}", componentBean);
        this.addELValues(this.variables, "#{%s}", componentBean);
        if (!ScriptOptionTemplateElement.isEmpty(this.name) && !ScriptOptionTemplateElement.isEmpty(this.value)) {
            this.values.add(new NameValuePair(this.name.trim(), ELParser.compileEL(this.value.trim(), componentBean)));
        }
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getBeginElement() throws CompilationException {
        VelocityContext context = new VelocityContext();
        context.put("mapName", (Object)ScriptObjectTemplateElement.getVariableName());
        context.put("valuesList", this.values);
        if (!ScriptOptionTemplateElement.isEmpty(this.defaultValue)) {
            context.put("defaultValue", (Object)this.defaultValue);
        } else {
            context.put("defaultValue", null);
        }
        context.put("wrapperName", (Object)this.wrapperName);
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    public String getEndElement() throws CompilationException {
        return null;
    }
}

