/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.templatecompiler.elements.vcp;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.ajax4jsf.templatecompiler.builder.CompilationContext;
import org.ajax4jsf.templatecompiler.builder.CompilationException;
import org.ajax4jsf.templatecompiler.elements.TemplateElementBase;
import org.apache.velocity.VelocityContext;
import org.w3c.dom.Node;

public abstract class HeaderResourceElement
extends TemplateElementBase {
    private static final String TEMPLATE = "META-INF/templates/templatecompiler/headerResource.vm";
    private static final String NEW = "new ";
    private String[] keys;
    private String[] resourcePaths;

    public HeaderResourceElement(Node element, CompilationContext componentBean) throws CompilationException {
        super(element, componentBean);
        String resourcesAsString = element.getTextContent();
        if (resourcesAsString != null) {
            resourcesAsString = resourcesAsString.trim();
            StringTokenizer tokenizer = new StringTokenizer(resourcesAsString, "\r\n\t,;");
            ArrayList<String> paths = new ArrayList<String>(tokenizer.countTokens());
            ArrayList<String> keyz = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String path;
                String token = tokenizer.nextToken().trim();
                if (token.startsWith(NEW)) {
                    keyz.add(token);
                    int idx = token.indexOf(40);
                    path = idx != -1 ? token.substring(0, idx).substring(NEW.length()).trim() : token.substring(NEW.length()).trim();
                } else {
                    keyz.add("getResource(\"" + token + "\")");
                    path = token;
                }
                paths.add(path);
            }
            this.keys = keyz.toArray(new String[keyz.size()]);
            this.resourcePaths = paths.toArray(new String[paths.size()]);
        }
        componentBean.addToImport("org.ajax4jsf.resource.InternetResource");
        componentBean.addToDeclaration(this.getContent());
    }

    private String getterMethodName(String propName) {
        return "get" + Character.toUpperCase(propName.charAt(0)) + propName.substring(1);
    }

    protected String getGetterModifier() {
        return "protected";
    }

    protected abstract String getPropertyName();

    public String getBeginElement() {
        return null;
    }

    private String getContent() throws CompilationException {
        VelocityContext context = new VelocityContext();
        String propertyName = this.getPropertyName();
        if (this.keys != null) {
            context.put("resourceKeys", (Object)this.keys);
        }
        context.put("propertyGetterName", (Object)this.getterMethodName(propertyName));
        context.put("property", (Object)propertyName);
        context.put("getterModifier", (Object)this.getGetterModifier());
        return this.getComponentBean().processTemplate(this.getTemplateName(), context);
    }

    protected String getTemplateName() {
        return TEMPLATE;
    }

    public String getEndElement() {
        return null;
    }

    public boolean isSkipBody() {
        return true;
    }

    public String[] getResourcePaths() {
        return this.resourcePaths;
    }
}

