/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarResourceScanner {
    private FileObject baseFile;
    private Set<FileObject> result = new HashSet<FileObject>();
    private String[] patterns = new String[]{"**"};

    public String[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    public FileObject getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(FileObject baseFile) {
        this.baseFile = baseFile;
    }

    protected boolean isAcceptable(FileObject fileObject) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (!SelectorUtils.matchPath((String)this.patterns[i], (String)fileObject.getName().getURI())) continue;
            return true;
        }
        return false;
    }

    protected void walk(FileObject file) throws IOException {
        FileObject[] children;
        for (FileObject child : children = file.getChildren()) {
            if (child.getType() != FileType.FILE) {
                this.walk(child);
                continue;
            }
            if (!this.isAcceptable(child)) continue;
            this.result.add(child);
        }
    }

    public void doScan() throws IOException {
        if (this.baseFile != null && this.baseFile.exists()) {
            this.walk(this.baseFile);
        }
    }

    public Set<FileObject> getResult() {
        return this.result;
    }

    public void setResult(Set<FileObject> result) {
        this.result = result;
    }
}

