/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.IOUtil;
import org.richfaces.cdk.rd.generator.ResourceAssembler;

public class ScriptAssembler
implements ResourceAssembler {
    protected Log log;
    private StringBuilder builder = new StringBuilder();

    public ScriptAssembler(Log log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assembly(URL resource) {
        InputStream inputStream = null;
        try {
            inputStream = resource.openStream();
            this.builder.append(IOUtil.toString((InputStream)inputStream));
            this.builder.append("\n");
        }
        catch (IOException e) {
            this.log.error((CharSequence)("Error read resource: " + resource.getFile()));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) {
        if (this.builder.length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                try {
                    this.log.info((CharSequence)("write result to the:  " + file.getPath()));
                    IOUtil.copy((String)this.builder.toString(), (Writer)fileWriter);
                }
                finally {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                this.log.error((CharSequence)("Error write file: " + file.getAbsolutePath()), (Throwable)e);
            }
        }
    }
}

