/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.rd.handler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.SelectorUtils;
import org.richfaces.cdk.rd.Component;
import org.richfaces.cdk.rd.Components;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsHandler
extends DefaultHandler {
    private String[] INCLUDE_ALL_PATTERN = new String[]{"**"};
    protected Log log;
    private Map<String, Components> components;
    private Map<String, Set<String>> processedComponents = new HashMap<String, Set<String>>();
    private Set<String> scripts = new LinkedHashSet<String>();
    private Set<String> styles = new LinkedHashSet<String>();
    private String[] scriptIncludes;
    private String[] scriptExcludes;
    private String[] styleIncludes;
    private String[] styleExcludes;
    private String[] namespaceIncludes;
    private String[] namespaceExcludes;
    private String[] componentIncludes;
    private String[] componentExcludes;
    private static final String DEFAULT_DTD_PATH = "org/richfaces/default.dtd";
    private String defaultDtdContent;

    public ComponentsHandler(Log log) {
        this.log = log;
    }

    private Set<String> getProcessedComponentsSet(String uri) {
        Set<String> result = this.processedComponents.get(uri);
        if (result == null) {
            result = new HashSet<String>();
            this.processedComponents.put(uri, result);
        }
        return result;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        Set<String> processedComponentsSet;
        Components library;
        if (this.components != null && (library = this.components.get(uri)) != null && (processedComponentsSet = this.getProcessedComponentsSet(uri)).add(localName)) {
            if (this.namespaceIncludes == null) {
                this.namespaceIncludes = this.INCLUDE_ALL_PATTERN;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)"use default include patterns for namespaces");
                }
            }
            if (this.doMatch(this.namespaceIncludes, uri, true)) {
                if (!this.doMatch(this.namespaceExcludes, uri, true)) {
                    List<Component> components = library.getComponents();
                    if (this.componentIncludes == null) {
                        this.componentIncludes = this.INCLUDE_ALL_PATTERN;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((CharSequence)"use default include patterns for components");
                        }
                    }
                    if (this.doMatch(this.componentIncludes, localName, false) && !this.doMatch(this.componentExcludes, localName, false)) {
                        for (Component component : components) {
                            String componentName = component.getComponentName();
                            if (!localName.equals(componentName)) continue;
                            this.log.info((CharSequence)("process component: " + componentName));
                            this.collectScripts(component);
                            this.collectStyles(component);
                            break;
                        }
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug((CharSequence)("components from namespace " + uri + " are in excluded list"));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("components from namespace " + uri + " aren't in include list"));
            }
        }
    }

    private void collectStyles(Component component) {
        if (this.styleIncludes == null) {
            this.styleIncludes = this.INCLUDE_ALL_PATTERN;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("start collect styles from component:  " + component.getComponentName()));
        }
        for (String style : component.getStyles()) {
            if (this.doMatch(this.styleIncludes, style, true)) {
                if (!this.doMatch(this.styleExcludes, style, true)) {
                    this.styles.add(style);
                    this.log.info((CharSequence)("style " + style + " is collected"));
                    continue;
                }
                this.log.info((CharSequence)"style files are in excluded list");
                for (String styleExclude : this.styleExcludes) {
                    this.log.info((CharSequence)styleExclude);
                }
                continue;
            }
            this.log.info((CharSequence)"style files are not in included list");
            for (String styleInclude : this.styleIncludes) {
                this.log.info((CharSequence)styleInclude);
            }
        }
    }

    private boolean doMatch(String[] patterns, String str, boolean matchPath) {
        boolean allow = false;
        if (patterns != null) {
            for (String excludePattern : patterns) {
                allow = matchPath ? SelectorUtils.matchPath((String)excludePattern, (String)str) : SelectorUtils.match((String)excludePattern, (String)str);
                if (allow) break;
            }
        }
        return allow;
    }

    private void collectScripts(Component component) {
        if (this.scriptIncludes == null) {
            this.scriptIncludes = this.INCLUDE_ALL_PATTERN;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("start collect scripts from component:  " + component.getComponentName()));
        }
        for (String script : component.getScripts()) {
            if (this.doMatch(this.scriptIncludes, script, true)) {
                if (!this.doMatch(this.scriptExcludes, script, true)) {
                    this.scripts.add(script);
                    this.log.info((CharSequence)("script " + script + " is collected"));
                    continue;
                }
                this.log.info((CharSequence)"script files are in excluded list");
                for (String styleExclude : this.scriptExcludes) {
                    this.log.info((CharSequence)styleExclude);
                }
                continue;
            }
            this.log.info((CharSequence)"script files are not in included list");
            for (String styleInclude : this.scriptIncludes) {
                this.log.info((CharSequence)styleInclude);
            }
        }
    }

    public Set<String> getStyles() {
        return this.styles;
    }

    public Set<String> getScripts() {
        return this.scripts;
    }

    public Map<String, Components> getComponents() {
        return this.components;
    }

    public void setComponents(Map<String, Components> components) {
        this.components = components;
    }

    public String[] getNamespaceExcludes() {
        return this.namespaceExcludes;
    }

    public void setNamespaceExcludes(String[] namespaceExcludes) {
        this.namespaceExcludes = namespaceExcludes;
    }

    public String[] getComponentExcludes() {
        return this.componentExcludes;
    }

    public void setComponentExcludes(String[] componentExcludes) {
        this.componentExcludes = componentExcludes;
    }

    public String[] getScriptExcludes() {
        return this.scriptExcludes;
    }

    public void setScriptExcludes(String[] scriptExcludes) {
        this.scriptExcludes = scriptExcludes;
    }

    public String[] getStyleExcludes() {
        return this.styleExcludes;
    }

    public void setStyleExcludes(String[] styleExcludes) {
        this.styleExcludes = styleExcludes;
    }

    public String[] getScriptIncludes() {
        return this.scriptIncludes;
    }

    public void setScriptIncludes(String[] scriptIncludes) {
        this.scriptIncludes = scriptIncludes;
    }

    public String[] getStyleIncludes() {
        return this.styleIncludes;
    }

    public void setStyleIncludes(String[] styleIncludes) {
        this.styleIncludes = styleIncludes;
    }

    public String[] getNamespaceIncludes() {
        return this.namespaceIncludes;
    }

    public void setNamespaceIncludes(String[] namespaceIncludes) {
        this.namespaceIncludes = namespaceIncludes;
    }

    public String[] getComponentIncludes() {
        return this.componentIncludes;
    }

    public void setComponentIncludes(String[] componentIncludes) {
        this.componentIncludes = componentIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readDtdContent(String path) throws IOException {
        String dtdContent;
        URL url = Thread.currentThread().getContextClassLoader().getResource(path);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(path);
        }
        InputStreamReader reader = new InputStreamReader(url.openStream());
        try {
            int read;
            StringBuilder builder = new StringBuilder(32);
            char[] cs = new char[512];
            while ((read = reader.read(cs)) != -1) {
                builder.append(cs, 0, read);
            }
            dtdContent = builder.toString();
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return dtdContent;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        if (this.defaultDtdContent == null) {
            this.defaultDtdContent = this.readDtdContent(DEFAULT_DTD_PATH);
        }
        return new InputSource(new StringReader(this.defaultDtdContent));
    }
}

