/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.handler.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.FileNameMapper;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.resource.VersionedResource;

public class DynamicResourceWrapper
extends Resource {
    private static final String ECSS_EXTENSION = ".ecss";
    private Resource resource;

    public DynamicResourceWrapper(Resource resource) {
        this.resource = resource;
    }

    public InputStream getInputStream() throws IOException {
        return this.resource.getInputStream();
    }

    public String getContentType() {
        return this.resource.getContentType();
    }

    public void setContentType(String contentType) {
        this.resource.setContentType(contentType);
    }

    public String getLibraryName() {
        return this.resource.getLibraryName();
    }

    public void setLibraryName(String libraryName) {
        this.resource.setLibraryName(libraryName);
    }

    public String getResourceName() {
        return this.resource.getResourceName();
    }

    public void setResourceName(String resourceName) {
        this.resource.setResourceName(resourceName);
    }

    public Map<String, String> getResponseHeaders() {
        throw new UnsupportedOperationException();
    }

    private String getMangledLibraryName() {
        String resourceName = this.getResourceName();
        if (Strings.isNullOrEmpty((String)this.getLibraryName()) && !resourceName.endsWith(ECSS_EXTENSION)) {
            int idx = resourceName.lastIndexOf(46);
            if (idx < 0) {
                return null;
            }
            return resourceName.substring(0, idx);
        }
        return this.getLibraryName();
    }

    private String getMangledResourceName() {
        String resourceName = this.getResourceName();
        if (resourceName.endsWith(ECSS_EXTENSION)) {
            return resourceName.substring(0, resourceName.length() - ECSS_EXTENSION.length());
        }
        if (Strings.isNullOrEmpty((String)this.getLibraryName())) {
            int idx = resourceName.lastIndexOf(46);
            if (idx < 0) {
                return resourceName;
            }
            return resourceName.substring(idx + 1);
        }
        return resourceName;
    }

    private FileNameMapper getFileNameMapper() {
        return (FileNameMapper)ServiceTracker.getService(FileNameMapper.class);
    }

    private String getVersion() {
        String version = null;
        if (this.resource instanceof VersionedResource) {
            version = ((VersionedResource)this.resource).getVersion();
        }
        return version;
    }

    public String getRequestPath() {
        String mangledLibraryName = this.getMangledLibraryName();
        String mangledResourceName = this.getMangledResourceName();
        String resourceExtension = this.getResourceExtension();
        String resourceName = Constants.DOT_JOINER.join((Object)Constants.DASH_JOINER.join((Object)mangledResourceName, (Object)this.getVersion(), new Object[0]), (Object)resourceExtension, new Object[0]);
        String resourcePath = Constants.SLASH_JOINER.join((Object)mangledLibraryName, (Object)resourceName, new Object[0]);
        return "%skin%/" + this.getFileNameMapper().createName(resourcePath);
    }

    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        throw new UnsupportedOperationException();
    }

    protected String getResourceExtension() {
        String[] split;
        String contentType = this.getContentType();
        if (contentType == null) {
            return null;
        }
        if ((contentType.startsWith("text/") || contentType.startsWith("image/")) && (split = contentType.split("/")).length == 2) {
            return split[1];
        }
        return null;
    }
}

