/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.naming;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.richfaces.cdk.FileNameMapper;

public class FileNameMapperImpl
implements FileNameMapper {
    private List<Mapping> fileNameMappings;

    public FileNameMapperImpl(Map<String, String> fileNameMappings) {
        this.fileNameMappings = FileNameMapperImpl.compileMappings(fileNameMappings);
    }

    private static List<Mapping> compileMappings(Map<String, String> mappings) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            String replacement = entry.getValue();
            result.add(new Mapping(pattern, replacement));
        }
        return result;
    }

    @Override
    public String createName(String resourcePath) {
        if (resourcePath == null) {
            return resourcePath;
        }
        for (Mapping mapping : this.fileNameMappings) {
            Matcher matcher = mapping.getPattern().matcher(resourcePath);
            if (!matcher.find()) continue;
            return matcher.replaceAll(mapping.getReplacement());
        }
        return resourcePath;
    }

    private static final class Mapping {
        private Pattern pattern;
        private String replacement;

        public Mapping(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

