/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.task;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.apache.maven.plugin.logging.Log;
import org.richfaces.cdk.Faces;
import org.richfaces.cdk.ResourceTaskFactory;
import org.richfaces.cdk.ResourceWriter;
import org.richfaces.cdk.faces.CurrentResourceContext;
import org.richfaces.resource.ResourceKey;

public class ResourceTaskFactoryImpl
implements ResourceTaskFactory {
    private Log log;
    private Faces faces;
    private ResourceWriter resourceWriter;
    private CompletionService<Object> completionService;
    private String[] skins = new String[0];
    private Predicate<Resource> filter = Predicates.alwaysTrue();

    public ResourceTaskFactoryImpl(Faces faces) {
        this.faces = faces;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    @Override
    public void setResourceWriter(ResourceWriter resourceWriter) {
        this.resourceWriter = resourceWriter;
    }

    @Override
    public void setSkins(String[] skins) {
        this.skins = skins;
    }

    @Override
    public void setCompletionService(CompletionService<Object> completionService) {
        this.completionService = completionService;
    }

    @Override
    public void setFilter(Predicate<Resource> filter) {
        this.filter = filter;
    }

    @Override
    public void submit(Iterable<ResourceKey> locators) {
        for (ResourceKey locator : locators) {
            this.completionService.submit(new ResourcesRendererCallable(locator));
        }
    }

    private class ResourcesRendererCallable
    implements Callable<Object> {
        private ResourceKey resourceInfo;
        private boolean skinDependent;
        private boolean skipped = false;

        ResourcesRendererCallable(ResourceKey resourceInfo) {
            this.resourceInfo = resourceInfo;
        }

        private Resource createResource(FacesContext facesContext, ResourceKey resourceInfo) {
            ResourceHandler resourceHandler = facesContext.getApplication().getResourceHandler();
            return resourceHandler.createResource(resourceInfo.getResourceName(), resourceInfo.getLibraryName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderResource(String skin) {
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.faces.setSkin(skin);
                }
                Resource resource = this.createResource(facesContext, this.resourceInfo);
                CurrentResourceContext.getInstance(facesContext).setResource(resource);
                ResourceTaskFactoryImpl.this.resourceWriter.writeResource(skin, resource);
            }
            catch (Exception e) {
                if (skin != null) {
                    ResourceTaskFactoryImpl.this.log.error((CharSequence)MessageFormat.format("Exception rendering resorce {0} using skin {1}: {2}", this.resourceInfo, skin, e.getMessage()), (Throwable)e);
                } else {
                    ResourceTaskFactoryImpl.this.log.error((CharSequence)MessageFormat.format("Exception rendering resorce {0}: {1}", this.resourceInfo, e.getMessage()), (Throwable)e);
                }
            }
            finally {
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkResource() {
            try {
                FacesContext facesContext = ResourceTaskFactoryImpl.this.faces.startRequest();
                ResourceTaskFactoryImpl.this.faces.setSkin("DEFAULT");
                Resource resource = this.createResource(facesContext, this.resourceInfo);
                if (resource == null) {
                    this.skipped = true;
                    return;
                }
                if (!ResourceTaskFactoryImpl.this.filter.apply((Object)resource)) {
                    this.skipped = true;
                    return;
                }
                String contentType = resource.getContentType();
                if (contentType == null) {
                    this.skipped = true;
                    return;
                }
                this.skinDependent = resource.getRequestPath().startsWith("%skin%/");
            }
            finally {
                ResourceTaskFactoryImpl.this.faces.setSkin(null);
                ResourceTaskFactoryImpl.this.faces.stopRequest();
            }
        }

        @Override
        public Object call() throws Exception {
            this.checkResource();
            if (!this.skipped) {
                if (this.skinDependent) {
                    for (String skin : ResourceTaskFactoryImpl.this.skins) {
                        this.renderResource(skin);
                    }
                } else {
                    this.renderResource(null);
                }
            }
            return null;
        }
    }
}

