/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.handler.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.activation.MimetypesFileTypeMap;
import javax.faces.application.Resource;
import org.richfaces.cdk.resource.handler.impl.AbstractResourceHandler;
import org.richfaces.cdk.resource.handler.impl.VFSResource;
import org.richfaces.cdk.resource.util.ResourceUtil;
import org.richfaces.cdk.vfs.VirtualFile;

public class StaticResourceHandler
extends AbstractResourceHandler {
    private Collection<VirtualFile> roots;

    public StaticResourceHandler(Collection<VirtualFile> roots) {
        this.roots = roots;
    }

    private VirtualFile findLibrary(String libraryName) {
        for (VirtualFile file : this.roots) {
            VirtualFile libraryDir;
            VirtualFile child = file.getChild(libraryName);
            if (child == null || (libraryDir = ResourceUtil.getLatestVersion(child, true)) == null) continue;
            return libraryDir;
        }
        return null;
    }

    private VirtualFile findResource(Collection<VirtualFile> libraryDirs, String resourceName) {
        for (VirtualFile libraryDir : libraryDirs) {
            VirtualFile resource;
            VirtualFile child = libraryDir.getChild(resourceName);
            if (child == null || (resource = ResourceUtil.getLatestVersion(child, false)) == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Resource createResource(String resourceName, String libraryName, String contentType) {
        List<VirtualFile> libraryDirs = Collections.emptyList();
        if (!Strings.isNullOrEmpty((String)libraryName)) {
            VirtualFile libraryDir = this.findLibrary(libraryName);
            if (libraryDir != null) {
                libraryDirs = Collections.singletonList(libraryDir);
            }
        } else {
            libraryDirs = this.roots;
        }
        VirtualFile resource = this.findResource(libraryDirs, resourceName);
        if (resource != null) {
            VFSResource result = new VFSResource(resource, resource.getRelativePath());
            result.setResourceName(resourceName);
            result.setLibraryName(libraryName);
            if (Strings.isNullOrEmpty((String)contentType)) {
                result.setContentType(MimetypesFileTypeMap.getDefaultFileTypeMap().getContentType(resourceName));
            } else {
                result.setContentType(contentType);
            }
            return result;
        }
        return null;
    }
}

