/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Constraints;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.richfaces.cdk.Faces;
import org.richfaces.cdk.FileNameMapping;
import org.richfaces.cdk.ProcessMode;
import org.richfaces.cdk.concurrent.CountingExecutorCompletionService;
import org.richfaces.cdk.faces.FacesImpl;
import org.richfaces.cdk.naming.FileNameMapperImpl;
import org.richfaces.cdk.resource.handler.impl.DynamicResourceHandler;
import org.richfaces.cdk.resource.handler.impl.StaticResourceHandler;
import org.richfaces.cdk.resource.scan.impl.DynamicResourcesScanner;
import org.richfaces.cdk.resource.scan.impl.StaticResourcesScanner;
import org.richfaces.cdk.resource.util.ResourceUtil;
import org.richfaces.cdk.resource.writer.ResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.CSSResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.JavaScriptResourceProcessor;
import org.richfaces.cdk.resource.writer.impl.ResourceWriterImpl;
import org.richfaces.cdk.task.ResourceTaskFactoryImpl;
import org.richfaces.cdk.util.MoreConstraints;
import org.richfaces.cdk.util.MorePredicates;
import org.richfaces.cdk.vfs.VFS;
import org.richfaces.cdk.vfs.VFSRoot;
import org.richfaces.cdk.vfs.VirtualFile;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceFactoryImpl;
import org.richfaces.resource.ResourceKey;

public class ProcessMojo
extends AbstractMojo {
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static final Function<String, Predicate<CharSequence>> REGEX_CONTAINS_BUILDER_FUNCTION = new Function<String, Predicate<CharSequence>>(){

        public Predicate<CharSequence> apply(String from) {
            Predicate containsPredicate = Predicates.containsPattern((String)from);
            return Predicates.and((Predicate)Predicates.notNull(), (Predicate)containsPredicate);
        }
    };
    private static final Function<Resource, String> CONTENT_TYPE_FUNCTION = new Function<Resource, String>(){

        public String apply(Resource from) {
            return from.getContentType();
        }
    };
    private static final Function<Resource, String> RESOURCE_QUALIFIER_FUNCTION = new Function<Resource, String>(){

        public String apply(Resource from) {
            return ResourceUtil.getResourceQualifier(from);
        }
    };
    private final Function<String, URL> filePathToURL = new Function<String, URL>(){

        public URL apply(String from) {
            try {
                File file = new File(from);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                ProcessMojo.this.getLog().error((CharSequence)"Bad URL in classpath", (Throwable)e);
            }
            return null;
        }
    };
    private String outputDir;
    private String[] skins;
    private MavenProject project;
    private List<String> includedContentTypes;
    private List<String> excludedContentTypes;
    private List<String> includedFiles;
    private List<String> excludedFiles;
    private FileNameMapping[] fileNameMappings = new FileNameMapping[0];
    private ProcessMode processMode = ProcessMode.embedded;
    private String webRoot;
    private String encoding;
    private Locale resourceLocales;
    private Collection<ResourceKey> foundResources = Sets.newHashSet();

    private static ExecutorService createExecutorService() {
        return Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    private Collection<ResourceProcessor> getDefaultResourceProcessors() {
        Charset charset = Charset.defaultCharset();
        if (!Strings.isNullOrEmpty((String)this.encoding)) {
            charset = Charset.forName(this.encoding);
        } else {
            this.getLog().warn((CharSequence)"Encoding is not set explicitly, CDK resources plugin will use default platform encoding for processing char-based resources");
        }
        return Arrays.asList(new JavaScriptResourceProcessor(charset, this.getLog()), new CSSResourceProcessor(charset));
    }

    private Predicate<Resource> createResourcesFilter() {
        Predicate<CharSequence> qualifierPredicate = MorePredicates.compose(this.includedFiles, this.excludedFiles, REGEX_CONTAINS_BUILDER_FUNCTION);
        Predicate qualifierResourcePredicate = Predicates.compose(qualifierPredicate, RESOURCE_QUALIFIER_FUNCTION);
        Predicate<CharSequence> contentTypePredicate = MorePredicates.compose(this.includedContentTypes, this.excludedContentTypes, REGEX_CONTAINS_BUILDER_FUNCTION);
        Predicate contentTypeResourcePredicate = Predicates.compose(contentTypePredicate, CONTENT_TYPE_FUNCTION);
        return Predicates.and((Predicate)qualifierResourcePredicate, (Predicate)contentTypeResourcePredicate);
    }

    private URL resolveWebRoot() throws MalformedURLException {
        File result = new File(this.webRoot);
        if (!result.exists()) {
            result = new File(this.project.getBasedir(), this.webRoot);
        }
        if (!result.exists()) {
            return null;
        }
        return result.toURI().toURL();
    }

    private void scanDynamicResources(Collection<VFSRoot> cpFiles, ResourceFactory resourceFactory) throws Exception {
        DynamicResourcesScanner scanner = new DynamicResourcesScanner(cpFiles, resourceFactory);
        scanner.scan();
        this.foundResources.addAll(scanner.getResources());
    }

    private void scanStaticResources(Collection<VirtualFile> resourceRoots) throws Exception {
        StaticResourcesScanner scanner = new StaticResourcesScanner(resourceRoots);
        scanner.scan();
        this.foundResources.addAll(scanner.getResources());
    }

    private Collection<VFSRoot> fromUrls(Iterable<URL> urls) throws URISyntaxException, IOException {
        ArrayList result = Lists.newArrayList();
        for (URL url : urls) {
            if (url == null) continue;
            VFSRoot vfsRoot = VFS.getRoot(url);
            vfsRoot.initialize();
            result.add(vfsRoot);
        }
        return result;
    }

    private Collection<VFSRoot> getClasspathVfs(URL[] urls) throws URISyntaxException, IOException {
        return this.fromUrls(Arrays.asList(urls));
    }

    private Collection<VFSRoot> getWebrootVfs() throws URISyntaxException, IOException {
        return this.fromUrls(Collections.singletonList(this.resolveWebRoot()));
    }

    protected URL[] getProjectClassPath() {
        try {
            List classpath = Constraints.constrainedList((List)Lists.newArrayList(), MoreConstraints.cast(String.class));
            classpath.addAll(this.project.getCompileClasspathElements());
            classpath.add(this.project.getBuild().getOutputDirectory());
            URL[] urlClasspath = Collections2.filter((Collection)Collections2.transform((Collection)classpath, this.filePathToURL), (Predicate)Predicates.notNull()).toArray(EMPTY_URL_ARRAY);
            return urlClasspath;
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().error((CharSequence)"Dependencies not resolved ", (Throwable)e);
            return new URL[0];
        }
    }

    protected ClassLoader createProjectClassLoader(URL[] cp) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = new URLClassLoader(cp, classLoader);
        return classLoader;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Collection<VFSRoot> webResources;
        ExecutorService executorService;
        Faces faces;
        ClassLoader contextCL;
        block27: {
            contextCL = Thread.currentThread().getContextClassLoader();
            faces = null;
            executorService = null;
            webResources = null;
            Collection<VFSRoot> cpResources = null;
            try {
                URL[] projectCP = this.getProjectClassPath();
                ClassLoader projectCL = this.createProjectClassLoader(projectCP);
                Thread.currentThread().setContextClassLoader(projectCL);
                webResources = this.getWebrootVfs();
                cpResources = this.getClasspathVfs(projectCP);
                Collection<VirtualFile> resourceRoots = ResourceUtil.getResourceRoots(cpResources, webResources);
                this.scanStaticResources(resourceRoots);
                StaticResourceHandler staticResourceHandler = new StaticResourceHandler(resourceRoots);
                ResourceFactoryImpl resourceFactory = new ResourceFactoryImpl((ResourceHandler)staticResourceHandler);
                this.scanDynamicResources(cpResources, (ResourceFactory)resourceFactory);
                File resourceOutputDir = new File(this.outputDir);
                if (!resourceOutputDir.exists()) {
                    resourceOutputDir = new File(this.project.getBuild().getDirectory(), this.outputDir);
                }
                File resourceMappingDir = new File(this.project.getBuild().getOutputDirectory());
                DynamicResourceHandler resourceHandler = new DynamicResourceHandler(staticResourceHandler, (ResourceFactory)resourceFactory);
                faces = new FacesImpl(null, new FileNameMapperImpl(this.fileNameMappings), resourceHandler);
                faces.start();
                ResourceWriterImpl resourceWriter = new ResourceWriterImpl(resourceOutputDir, resourceMappingDir, this.getDefaultResourceProcessors(), this.getLog());
                ResourceTaskFactoryImpl taskFactory = new ResourceTaskFactoryImpl(faces);
                taskFactory.setResourceWriter(resourceWriter);
                executorService = ProcessMojo.createExecutorService();
                CountingExecutorCompletionService<Object> completionService = new CountingExecutorCompletionService<Object>(executorService);
                taskFactory.setCompletionService(completionService);
                taskFactory.setSkins(this.skins);
                taskFactory.setLog(this.getLog());
                taskFactory.setFilter(this.createResourcesFilter());
                taskFactory.submit(this.foundResources);
                Future future = null;
                while ((future = completionService.take()) != null) {
                    try {
                        future.get();
                    }
                    catch (ExecutionException e) {
                        e.getCause().printStackTrace();
                    }
                }
                resourceWriter.writeProcessedResourceMappings();
                if (cpResources == null) break block27;
            }
            catch (Exception e) {
                try {
                    throw new MojoExecutionException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (cpResources != null) {
                        for (VFSRoot vfsRoot : cpResources) {
                            try {
                                vfsRoot.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    if (webResources != null) {
                        for (VFSRoot vfsRoot : webResources) {
                            try {
                                vfsRoot.close();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                    }
                    if (executorService != null) {
                        executorService.shutdown();
                    }
                    if (faces != null) {
                        faces.stop();
                    }
                    Thread.currentThread().setContextClassLoader(contextCL);
                    throw throwable;
                }
            }
            for (VFSRoot vfsRoot : cpResources) {
                try {
                    vfsRoot.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (webResources != null) {
            for (VFSRoot vfsRoot : webResources) {
                try {
                    vfsRoot.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (executorService != null) {
            executorService.shutdown();
        }
        if (faces != null) {
            faces.stop();
        }
        Thread.currentThread().setContextClassLoader(contextCL);
    }
}

