/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.resource.scan.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.richfaces.cdk.resource.scan.ResourcesScanner;
import org.richfaces.cdk.resource.util.ResourceUtil;
import org.richfaces.cdk.vfs.VirtualFile;
import org.richfaces.resource.ResourceKey;

public class StaticResourcesScanner
implements ResourcesScanner {
    private Collection<ResourceKey> resources = Sets.newHashSet();
    private Collection<VirtualFile> resourceRoots;

    public StaticResourcesScanner(Collection<VirtualFile> resourceRoots) {
        this.resourceRoots = resourceRoots;
    }

    private void scanResourcesRoot(VirtualFile file) {
        if (file == null) {
            return;
        }
        Collection<VirtualFile> children = file.getChildren();
        for (VirtualFile child : children) {
            if (child.isFile()) {
                this.resources.add(ResourceKey.create((String)child.getName()));
                continue;
            }
            String libraryName = child.getName();
            VirtualFile libraryDir = ResourceUtil.getLatestVersion(child, true);
            if (libraryDir == null) continue;
            this.scanLibrary(libraryName, libraryDir);
        }
    }

    private void scanLibrary(String libraryName, VirtualFile dir) {
        Collection<VirtualFile> children = dir.getChildren();
        for (VirtualFile child : children) {
            if (child.isFile()) {
                this.resources.add(new ResourceKey(child.getName(), libraryName));
                continue;
            }
            VirtualFile resource = ResourceUtil.getLatestVersion(child, false);
            if (resource == null) continue;
            this.resources.add(new ResourceKey(child.getName(), libraryName));
        }
    }

    @Override
    public void scan() throws Exception {
        for (VirtualFile resourceRoot : this.resourceRoots) {
            this.scanResourcesRoot(resourceRoot);
        }
    }

    @Override
    public Collection<ResourceKey> getResources() {
        return this.resources;
    }
}

