/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cdk.vfs.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.richfaces.cdk.strings.Constants;
import org.richfaces.cdk.vfs.VFSRoot;
import org.richfaces.cdk.vfs.VFSType;
import org.richfaces.cdk.vfs.zip.ZipNode;
import org.richfaces.cdk.vfs.zip.ZipVFSFile;

public class ZipVFSRoot
extends ZipVFSFile
implements VFSRoot {
    private File file;

    public ZipVFSRoot(File file) throws IOException {
        super(new ZipFile(file), new ZipNode(null), null);
        assert (file.isFile() && file.exists());
        this.file = file;
    }

    @Override
    public void initialize() throws IOException {
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            Iterable split = Constants.SLASH_SPLITTER.split((CharSequence)entryName);
            ZipNode node = this.getZipNode();
            for (String pathSeg : split) {
                if (".".equals(pathSeg) || "..".equals(pathSeg)) continue;
                node = node.getOrCreateChild(pathSeg);
            }
            node.setZipEntry(entry);
        }
    }

    @Override
    public void close() throws IOException {
        this.getZipFile().close();
    }

    @Override
    public VFSType getType() {
        return VFSType.zip;
    }

    @Override
    public URL toURL() throws MalformedURLException {
        return this.file.toURI().toURL();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new IOException("Stream is not available");
    }
}

