/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.component.AbstractAjaxStatus;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.javascript.JSFunction;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RendererBase;
import org.richfaces.renderkit.util.HandlersChain;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(library="org.richfaces", name="jquery.js"), @ResourceDependency(library="org.richfaces", name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(library="org.richfaces", name="richfaces-base-component.js"), @ResourceDependency(library="org.richfaces", name="status.js")})
public class AjaxStatusRenderer
extends RendererBase {
    private static final String START = "start";
    private static final String STOP = "stop";
    private static final String ERROR = "error";
    private static final String[] EVENT_NAMES = new String[]{"start", "stop", "error", "success"};

    protected void encodeState(FacesContext facesContext, AbstractAjaxStatus status, StatusState state) throws IOException {
        Map statusAttributes = status.getAttributes();
        UIComponent stateFacet = status.getFacet(state.getFacetName());
        String stateText = null;
        if (stateFacet == null) {
            stateText = (String)statusAttributes.get(state.getTextAttributeName());
        }
        if (state.isOptional() && stateFacet == null && stateText == null) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("span", (UIComponent)status);
        String stateStyle = (String)statusAttributes.get(state.getStyleAttributeName());
        RenderKitUtils.renderAttribute((FacesContext)facesContext, (String)"style", (Object)HtmlUtil.concatStyles(stateStyle, state.isInitial() ? null : "display:none"));
        String stateStyleClass = (String)statusAttributes.get(state.getStyleClassAttributeName());
        RenderKitUtils.renderAttribute((FacesContext)facesContext, (String)"class", (Object)HtmlUtil.concatClasses(state.getDefaultStyleClass(), stateStyleClass));
        if (stateFacet != null && stateFacet.isRendered()) {
            stateFacet.encodeAll(facesContext);
        } else if (stateText != null) {
            writer.writeText((Object)stateText, null);
        }
        writer.endElement("span");
    }

    public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeEnd(writer, context, component);
        AbstractAjaxStatus ajaxStatus = (AbstractAjaxStatus)component;
        writer.startElement("span", component);
        String clientId = component.getClientId(context);
        writer.writeAttribute("id", (Object)clientId, "id");
        for (StatusState state : StatusState.values()) {
            this.encodeState(context, ajaxStatus, state);
        }
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        JSFunction statusConstructor = new JSFunction("new RichFaces.rf4.ui.Status", new Object[]{clientId});
        HashMap options = new HashMap();
        Map attributes = ajaxStatus.getAttributes();
        for (String eventName : EVENT_NAMES) {
            String eventAttribute = "on" + eventName;
            HandlersChain handlersChain = new HandlersChain(context, component, true);
            handlersChain.addInlineHandlerFromAttribute(eventAttribute);
            handlersChain.addBehaviors(eventName);
            RenderKitUtils.addToScriptHash(options, (String)eventAttribute, (Object)handlersChain.toScript(), null, (RenderKitUtils.ScriptHashVariableWrapper)RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        }
        RenderKitUtils.addToScriptHash(options, (String)"statusName", attributes.get("name"));
        if (!options.isEmpty()) {
            statusConstructor.addParameter(options);
        }
        writer.writeText((Object)statusConstructor.toScript(), null);
        writer.endElement("script");
        writer.endElement("span");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractAjaxStatus.class;
    }

    private static enum StatusState {
        start("start"),
        error("error"){
            {
                this.setOptional();
            }
        }
        ,
        stop("stop"){
            {
                this.setInitial();
            }
        };

        private String stateName;
        private String styleAttributeName;
        private String styleClassAttributeName;
        private String textAttributeName;
        private String defaultStyleClass;
        private boolean initial;
        private boolean optional;

        private StatusState(String stateName) {
            this.stateName = stateName;
            this.styleAttributeName = stateName + "Style";
            this.styleClassAttributeName = stateName + "StyleClass";
            this.textAttributeName = stateName + "Text";
            this.defaultStyleClass = "rf-st-" + stateName;
        }

        public String getStyleAttributeName() {
            return this.styleAttributeName;
        }

        public String getStyleClassAttributeName() {
            return this.styleClassAttributeName;
        }

        public String getFacetName() {
            return this.stateName;
        }

        public String getTextAttributeName() {
            return this.textAttributeName;
        }

        public String getDefaultStyleClass() {
            return this.defaultStyleClass;
        }

        public boolean isInitial() {
            return this.initial;
        }

        public boolean isOptional() {
            return this.optional;
        }

        protected void setOptional() {
            this.optional = true;
        }

        protected void setInitial() {
            this.initial = true;
        }
    }
}

