/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.application.ViewHandler;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.javascript.JSReference;
import org.richfaces.l10n.Messages;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.util.HandlersChain;
import org.richfaces.ui.ajax.parameter.JavaScriptParameter;
import org.richfaces.ui.common.HtmlConstants;
import org.richfaces.util.HtmlDimensions;

public final class _RendererUtils {
    public static final String DUMMY_FORM_ID = ":_form";
    private static final _RendererUtils INSTANCE = new _RendererUtils();
    private static final Map<String, String> SUBSTITUTIONS = new HashMap<String, String>();

    protected _RendererUtils() {
    }

    public static _RendererUtils getInstance() {
        return INSTANCE;
    }

    public void encodeId(FacesContext context, UIComponent component) throws IOException {
        this.encodeId(context, component, "id");
    }

    public void encodeId(FacesContext context, UIComponent component, String attribute) throws IOException {
        String clientId = null;
        try {
            clientId = component.getClientId(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null != clientId) {
            context.getResponseWriter().writeAttribute(attribute, (Object)clientId, (String)this.getComponentAttributeName(attribute));
        }
    }

    public void encodeCustomId(FacesContext context, UIComponent component) throws IOException {
        if (this.hasExplicitId(component)) {
            context.getResponseWriter().writeAttribute("id", (Object)component.getClientId(context), "id");
        }
    }

    public Object createParameterValue(UIParameter parameter) {
        Object value = parameter.getValue();
        boolean escape = true;
        if (parameter instanceof JavaScriptParameter) {
            JavaScriptParameter actionParam = (JavaScriptParameter)parameter;
            boolean bl = escape = !actionParam.isNoEscape();
        }
        if (escape) {
            if (value == null) {
                value = "";
            }
        } else {
            value = new JSReference(value.toString());
        }
        return value;
    }

    public Map<String, Object> createParametersMap(FacesContext context, UIComponent component) {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                if (!(child instanceof UIParameter)) continue;
                UIParameter parameter = (UIParameter)child;
                String name = parameter.getName();
                Object value = this.createParameterValue(parameter);
                if (null == name) {
                    throw new IllegalArgumentException(Messages.getMessage((String)"UNNAMED_PARAMETER_ERROR", (Object)component.getClientId(context)));
                }
                parameters.put(name, value);
            }
        }
        return parameters;
    }

    private void encodeBehaviors(FacesContext context, ClientBehaviorHolder behaviorHolder, String defaultHtmlEventName, String[] attributesExclusions) throws IOException {
        String defaultEventName = behaviorHolder.getDefaultEventName();
        Collection eventNames = behaviorHolder.getEventNames();
        if (eventNames != null) {
            UIComponent component = (UIComponent)behaviorHolder;
            ResponseWriter writer = context.getResponseWriter();
            List<ClientBehaviorContext.Parameter> parametersList = HandlersChain.createParametersList(this.createParametersMap(context, component));
            for (String behaviorEventName : eventNames) {
                if (behaviorEventName.equals(defaultEventName)) continue;
                String htmlEventName = "on" + behaviorEventName;
                if (attributesExclusions != null && Arrays.binarySearch(attributesExclusions, htmlEventName) >= 0) continue;
                HandlersChain handlersChain = new HandlersChain(context, component, parametersList);
                handlersChain.addInlineHandlerFromAttribute(htmlEventName);
                handlersChain.addBehaviors(behaviorEventName);
                String handlerScript = handlersChain.toScript();
                if (this.isEmpty(handlerScript)) continue;
                writer.writeAttribute(htmlEventName, (Object)handlerScript, htmlEventName);
            }
        }
    }

    public void encodePassThru(FacesContext context, UIComponent component, String defaultHtmlEvent) throws IOException {
        this.encodeAttributesFromArray(context, component, HtmlConstants.PASS_THRU);
        if (component instanceof ClientBehaviorHolder) {
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)component;
            this.encodeBehaviors(context, clientBehaviorHolder, defaultHtmlEvent, null);
        } else {
            this.encodeAttributesFromArray(context, component, HtmlConstants.PASS_THRU_EVENTS);
        }
    }

    public void encodePassThruWithExclusions(FacesContext context, UIComponent component, String exclusions, String defaultHtmlEvent) throws IOException {
        if (null != exclusions) {
            String[] exclusionsArray = exclusions.split(",");
            this.encodePassThruWithExclusionsArray(context, component, exclusionsArray, defaultHtmlEvent);
        }
    }

    public void encodePassThruWithExclusionsArray(FacesContext context, UIComponent component, String[] exclusions, String defaultHtmlEvent) throws IOException {
        String attribute;
        int i;
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = component.getAttributes();
        Arrays.sort(exclusions);
        for (i = 0; i < HtmlConstants.PASS_THRU.length; ++i) {
            attribute = HtmlConstants.PASS_THRU[i];
            if (Arrays.binarySearch(exclusions, attribute) >= 0) continue;
            this.encodePassThruAttribute(context, attributes, writer, attribute);
        }
        if (component instanceof ClientBehaviorHolder) {
            ClientBehaviorHolder clientBehaviorHolder = (ClientBehaviorHolder)component;
            this.encodeBehaviors(context, clientBehaviorHolder, defaultHtmlEvent, exclusions);
        } else {
            for (i = 0; i < HtmlConstants.PASS_THRU_EVENTS.length; ++i) {
                attribute = HtmlConstants.PASS_THRU_EVENTS[i];
                if (Arrays.binarySearch(exclusions, attribute) >= 0) continue;
                this.encodePassThruAttribute(context, attributes, writer, attribute);
            }
        }
    }

    public void encodePassThruAttribute(FacesContext context, Map<String, Object> attributes, ResponseWriter writer, String attribute) throws IOException {
        Object value = this.attributeValue(attribute, attributes.get(this.getComponentAttributeName(attribute)));
        if (null != value && RenderKitUtils.shouldRenderAttribute((Object)value)) {
            if (Arrays.binarySearch(HtmlConstants.PASS_THRU_URI, attribute) >= 0) {
                String url = context.getApplication().getViewHandler().getResourceURL(context, value.toString());
                url = context.getExternalContext().encodeResourceURL(url);
                writer.writeURIAttribute(attribute, (Object)url, attribute);
            } else {
                writer.writeAttribute(attribute, value, attribute);
            }
        }
    }

    public void encodeAttributesFromArray(FacesContext context, UIComponent component, String[] attrs) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map attributes = component.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            String attribute = attrs[i];
            this.encodePassThruAttribute(context, attributes, writer, attribute);
        }
    }

    public void encodeAttributes(FacesContext context, UIComponent component, String attrs) throws IOException {
        if (null != attrs) {
            String[] attrsArray = attrs.split(",");
            this.encodeAttributesFromArray(context, component, attrsArray);
        }
    }

    public void encodeAttribute(FacesContext context, UIComponent component, Object property, String attributeName) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object value = component.getAttributes().get(property);
        if (RenderKitUtils.shouldRenderAttribute(value)) {
            writer.writeAttribute(attributeName, value, property.toString());
        }
    }

    public void encodeAttribute(FacesContext context, UIComponent component, String attribute) throws IOException {
        this.encodeAttribute(context, component, this.getComponentAttributeName(attribute), attribute);
    }

    public boolean isEmpty(Object o) {
        if (null == o) {
            return true;
        }
        if (o instanceof String) {
            return 0 == ((String)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        return false;
    }

    protected Object getComponentAttributeName(Object key) {
        String converted = SUBSTITUTIONS.get(key);
        if (null == converted) {
            return key;
        }
        return converted;
    }

    protected Object attributeValue(String name, Object value) {
        if (null == value || Arrays.binarySearch(HtmlConstants.PASS_THRU_BOOLEAN, name) < 0) {
            return value;
        }
        boolean checked = value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
        return checked ? name : null;
    }

    public boolean isBooleanAttribute(UIComponent component, String name) {
        Object attrValue = component.getAttributes().get(name);
        boolean result = false;
        if (null != attrValue) {
            result = attrValue instanceof String ? "true".equalsIgnoreCase((String)attrValue) : Boolean.TRUE.equals(attrValue);
        }
        return result;
    }

    public String encodePx(String value) {
        return HtmlDimensions.formatPx((Double)HtmlDimensions.decode((String)value));
    }

    public String encodePctOrPx(String value) {
        if (value.indexOf(37) > 0) {
            return value;
        }
        return this.encodePx(value);
    }

    public UIComponent getNestingForm(UIComponent component) {
        return this.getNestingForm(null, component);
    }

    @Deprecated
    public UIComponent getNestingForm(FacesContext context, UIComponent component) {
        UIComponent parent;
        for (parent = component; !(parent == null || parent instanceof UIForm || "org.apache.myfaces.trinidad.Form".equals(parent.getFamily()) || "oracle.adf.Form".equals(parent.getFamily())); parent = parent.getParent()) {
        }
        return parent;
    }

    public UIComponent getSubmittedForm(FacesContext facesContext) {
        if (!facesContext.isPostback()) {
            return null;
        }
        for (Map.Entry entry : facesContext.getExternalContext().getRequestParameterMap().entrySet()) {
            String value;
            String name = (String)entry.getKey();
            if (!this.isFormValueSubmitted(name, value = (String)entry.getValue())) continue;
            UIComponent component = this.findComponentFor((UIComponent)facesContext.getViewRoot(), name);
            UIComponent form = this.getNestingForm(component);
            return form;
        }
        facesContext.addMessage(null, new FacesMessage("The form wasn't detected for the request", "The form wasn't detected for the request - rendering does not have to behave well"));
        return null;
    }

    public boolean isFormSubmitted(FacesContext context, UIForm form) {
        if (form != null) {
            String clientId = form.getClientId(context);
            String formRequestParam = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
            return this.isFormValueSubmitted(clientId, formRequestParam);
        }
        return false;
    }

    private boolean isFormValueSubmitted(String clientId, String value) {
        if (clientId == null) {
            return false;
        }
        return clientId.equals(value);
    }

    public void encodeBeginFormIfNessesary(FacesContext context, UIComponent component) throws IOException {
        UIComponent form = this.getNestingForm(context, component);
        if (null == form) {
            ResponseWriter writer = context.getResponseWriter();
            String clientId = component.getClientId(context) + DUMMY_FORM_ID;
            this.encodeBeginForm(context, component, writer, clientId);
        }
    }

    public void encodeBeginForm(FacesContext context, UIComponent component, ResponseWriter writer, String clientId) throws IOException {
        String actionURL = this.getActionUrl(context);
        String encodeActionURL = context.getExternalContext().encodeActionURL(actionURL);
        writer.startElement("form", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("method", (Object)"post", null);
        writer.writeAttribute("style", (Object)"margin:0; padding:0; display: inline;", null);
        writer.writeURIAttribute("action", (Object)encodeActionURL, "action");
    }

    public void encodeEndFormIfNessesary(FacesContext context, UIComponent component) throws IOException {
        UIComponent form = this.getNestingForm(context, component);
        if (null == form) {
            ResponseWriter writer = context.getResponseWriter();
            this.encodeEndForm(context, writer);
        }
    }

    public static void writeState(FacesContext context) throws IOException {
        context.getApplication().getViewHandler().writeState(context);
    }

    public void encodeEndForm(FacesContext context, ResponseWriter writer) throws IOException {
        UIViewRoot viewRoot = context.getViewRoot();
        for (UIComponent resource : viewRoot.getComponentResources(context, "form")) {
            resource.encodeAll(context);
        }
        _RendererUtils.writeState(context);
        writer.endElement("form");
    }

    public String getActionUrl(FacesContext facesContext) {
        ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
        String viewId = facesContext.getViewRoot().getViewId();
        return viewHandler.getActionURL(facesContext, viewId);
    }

    public String clientId(FacesContext context, UIComponent component) {
        String clientId = "";
        try {
            clientId = component.getClientId(context);
        }
        catch (Exception e) {
            // empty catch block
        }
        return clientId;
    }

    public void writeScript(FacesContext context, UIComponent component, Object script) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", "type");
        writer.writeText(script, null);
        writer.endElement("script");
    }

    public String correctForIdReference(String forAttr, UIComponent component) {
        String id;
        int pos;
        int contains = forAttr.indexOf("j_id");
        if (contains <= 0 && (pos = (id = component.getId()).indexOf("j_id")) > 0) {
            return forAttr.concat(id.substring(pos));
        }
        return forAttr;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                child.encodeAll(context);
            }
        }
    }

    public boolean hasExplicitId(UIComponent component) {
        return component.getId() != null && !component.getId().startsWith("j_id");
    }

    public UIComponent findComponentFor(FacesContext context, UIComponent component, String id) {
        return this.findComponentFor(component, id);
    }

    public UIComponent findComponentFor(UIComponent component, String id) {
        if (id == null) {
            throw new NullPointerException("id is null!");
        }
        if (id.length() == 0) {
            return null;
        }
        UIComponent target = null;
        UIComponent root = component;
        for (UIComponent parent = component; null == target && null != parent; parent = parent.getParent()) {
            target = parent.findComponent(id);
            root = parent;
        }
        if (null == target) {
            target = this.findUIComponentBelow(root, id);
        }
        return target;
    }

    private UIComponent findUIComponentBelow(UIComponent root, String id) {
        UIComponent target = null;
        Iterator iter = root.getFacetsAndChildren();
        while (iter.hasNext()) {
            UIComponent child = (UIComponent)iter.next();
            if (child instanceof NamingContainer) {
                try {
                    target = child.findComponent(id);
                }
                catch (IllegalArgumentException iae) {
                    continue;
                }
            }
            if (target == null && (child.getChildCount() > 0 || child.getFacetCount() > 0)) {
                target = this.findUIComponentBelow(child, id);
            }
            if (target == null) continue;
            break;
        }
        return target;
    }

    static {
        SUBSTITUTIONS.put("class", "styleClass");
        Arrays.sort(HtmlConstants.PASS_THRU);
        Arrays.sort(HtmlConstants.PASS_THRU_EVENTS);
        Arrays.sort(HtmlConstants.PASS_THRU_BOOLEAN);
        Arrays.sort(HtmlConstants.PASS_THRU_URI);
    }
}

