/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.highlight;

import com.uwyn.jhighlight.highlighter.ExplicitStateHighlighter;
import com.uwyn.jhighlight.renderer.XhtmlRenderer;
import com.uwyn.jhighlight.tools.StringUtils;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Formattable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.css.core.internal.parser.CSSTokenizer;
import org.richfaces.highlight.IStyleConstantsCSS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssXhtmlRenderer
extends XhtmlRenderer {
    private static final Map<String, Color> fContextToStyleMap = new HashMap<String, Color>();
    private static final String classTemplate = ".css_%s";
    private static final String colorTemplate = "color:%s;";
    private static final String tokenTemplate = "<span class=\"css_%s\">%s</span>";
    private static final Map<String, String> tokenClasses = new HashMap<String, String>();
    private Map<String, String> defaultCss = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String path = "D:\\eclipse\\rf\\rf3\\samples\\richfaces-demo\\src\\main\\webapp\\css\\common.css";
        if (args.length > 0) {
            path = args[0];
        }
        FileReader fileReader = new FileReader(path);
        try {
            new CssXhtmlRenderer().highlight("aaaa", new FileInputStream(path), (OutputStream)new FileOutputStream("css.html"), null, false);
        }
        finally {
            fileReader.close();
        }
    }

    private void generateClassesForTokens() {
        HashMap<WrapperBean<Color>, String> fieldMap = new HashMap<WrapperBean<Color>, String>();
        try {
            Field[] fields = IStyleConstantsCSS.class.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
                String name = field.getName().toLowerCase();
                Object object = field.get(null);
                if (!(object instanceof Color)) continue;
                fieldMap.put(new WrapperBean<Color>((Color)object), name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, Color> entry : fContextToStyleMap.entrySet()) {
            String token = entry.getKey();
            Color color = entry.getValue();
            WrapperBean<Color> bean = new WrapperBean<Color>(color);
            String string = (String)fieldMap.get(bean);
            tokenClasses.put(token, string);
        }
    }

    public Map<String, String> generateCSSTemplate() {
        HashMap<String, String> m = new HashMap<String, String>();
        Field[] fields = IStyleConstantsCSS.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers)) continue;
            String name = field.getName().toLowerCase();
            try {
                Object object = field.get(null);
                if (!(object instanceof Color)) continue;
                FormattableColor color = new FormattableColor((Color)object);
                m.put(String.format(classTemplate, name), String.format(colorTemplate, color));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassForToken(String token) {
        Map<String, String> map = tokenClasses;
        synchronized (map) {
            if (tokenClasses.isEmpty()) {
                this.generateClassesForTokens();
            }
        }
        return tokenClasses.get(token);
    }

    protected String getCssClass(int arg0) {
        return null;
    }

    protected synchronized Map<String, String> getDefaultCssStyles() {
        if (this.defaultCss == null) {
            this.defaultCss = this.generateCSSTemplate();
        }
        return this.defaultCss;
    }

    protected ExplicitStateHighlighter getHighlighter() {
        return null;
    }

    public void highlight(String name, InputStream in, OutputStream out, String encoding, boolean fragment) throws IOException {
        int read;
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        StringBuffer b = new StringBuffer();
        char[] buffer = new char[1024];
        while ((read = reader.read(buffer)) != -1) {
            b.append(buffer, 0, read);
        }
        this.highlight(name, b.toString(), out, encoding, fragment);
    }

    private void highlight(String name, String in, OutputStream output, String encoding, boolean fragment) throws IOException {
        String string = StringUtils.convertTabsToSpaces((String)in, (int)4);
        PrintWriter out = new PrintWriter(output);
        if (fragment) {
            out.write(this.getXhtmlHeaderFragment(name));
        } else {
            out.write(this.getXhtmlHeader(name));
        }
        CSSTokenizer tokenizer = new CSSTokenizer((Reader)new StringReader(string));
        while (!tokenizer.isEOF()) {
            String token = tokenizer.primGetNextToken();
            if (token != null) {
                String text = tokenizer.yytext();
                out.printf(tokenTemplate, new FormattableToken(token), new XHTMLString(text));
                continue;
            }
            if (tokenizer.yylength() <= 0) continue;
            throw new IllegalStateException();
        }
        if (!fragment) {
            out.write(this.getXhtmlFooter());
        }
        out.flush();
        out.close();
    }

    public String highlight(String name, String in, String encoding, boolean fragment) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        this.highlight(name, in, (OutputStream)s, encoding, fragment);
        s.flush();
        s.close();
        return encoding == null ? s.toString() : s.toString(encoding);
    }

    static {
        fContextToStyleMap.put("COMMENT", IStyleConstantsCSS.COMMENT);
        fContextToStyleMap.put("CDO", IStyleConstantsCSS.COMMENT);
        fContextToStyleMap.put("CDC", IStyleConstantsCSS.COMMENT);
        fContextToStyleMap.put("S", IStyleConstantsCSS.NORMAL);
        fContextToStyleMap.put("DELIMITER", IStyleConstantsCSS.SEMI_COLON);
        fContextToStyleMap.put("LBRACE", IStyleConstantsCSS.CURLY_BRACE);
        fContextToStyleMap.put("RBRACE", IStyleConstantsCSS.CURLY_BRACE);
        fContextToStyleMap.put("IMPORT", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("PAGE", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("MEDIA", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("FONT_FACE", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("CHARSET", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("ATKEYWORD", IStyleConstantsCSS.ATMARK_RULE);
        fContextToStyleMap.put("STRING", IStyleConstantsCSS.STRING);
        fContextToStyleMap.put("URI", IStyleConstantsCSS.URI);
        fContextToStyleMap.put("MEDIUM", IStyleConstantsCSS.MEDIA);
        fContextToStyleMap.put("MEDIA_SEPARATOR", IStyleConstantsCSS.MEDIA);
        fContextToStyleMap.put("CHARSET_NAME", IStyleConstantsCSS.STRING);
        fContextToStyleMap.put("CSS_PAGE_SELECTOR", IStyleConstantsCSS.MEDIA);
        fContextToStyleMap.put("SELECTOR_ELEMENT_NAME", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_UNIVERSAL", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_PSEUDO", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_CLASS", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ID", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_COMBINATOR", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_SEPARATOR", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ATTRIBUTE_START", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ATTRIBUTE_END", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ATTRIBUTE_NAME", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ATTRIBUTE_VALUE", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("SELECTOR_ATTRIBUTE_OPERATOR", IStyleConstantsCSS.SELECTOR);
        fContextToStyleMap.put("DECLARATION_PROPERTY", IStyleConstantsCSS.PROPERTY_NAME);
        fContextToStyleMap.put("DECLARATION_VALUE_IDENT", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_DIMENSION", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_PERCENTAGE", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_NUMBER", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_FUNCTION", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_PARENTHESIS_CLOSE", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_STRING", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_URI", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_HASH", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_UNICODE_RANGE", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("CSS_DECLARATION_VALUE_IMPORTANT", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_OPERATOR", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_VALUE_S", IStyleConstantsCSS.PROPERTY_VALUE);
        fContextToStyleMap.put("DECLARATION_SEPARATOR", IStyleConstantsCSS.COLON);
        fContextToStyleMap.put("DECLARATION_DELIMITER", IStyleConstantsCSS.SEMI_COLON);
        fContextToStyleMap.put("UNKNOWN", IStyleConstantsCSS.ERROR);
    }

    class FormattableColor
    implements Formattable {
        private Color color;

        public FormattableColor(Color color) {
            this.color = color;
        }

        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            try {
                formatter.out().append("#").append(Integer.toHexString(this.color.getRGB()).substring(2).toUpperCase());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class XHTMLString
    implements Formattable {
        private String text;

        public XHTMLString(String text) {
            this.text = text;
        }

        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            String s = StringUtils.replace((String)StringUtils.encodeHtml((String)this.text), (String)" ", (String)"&nbsp;").replaceAll("\\r?\\n", "<br />\n");
            try {
                formatter.out().append(s);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class FormattableToken
    implements Formattable {
        private String token;

        public FormattableToken(String token) {
            this.token = token;
        }

        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            try {
                formatter.out().append(CssXhtmlRenderer.this.getClassForToken(this.token));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WrapperBean<T> {
        private T wrapped;

        public WrapperBean(T wrapped) {
            this.wrapped = wrapped;
        }

        public boolean equals(Object obj) {
            return ((WrapperBean)obj).get() == this.wrapped;
        }

        public T get() {
            return this.wrapped;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        public String toString() {
            return super.toString();
        }
    }
}

