/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.highlight;

import com.uwyn.jhighlight.renderer.Renderer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class XhtmlRendererFactory {
    private static XhtmlRendererFactory instance;
    public static final String fileName = "renderers.properties";
    private Map<Object, Object> classNames = new HashMap<Object, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final XhtmlRendererFactory instance() {
        Class<XhtmlRendererFactory> clazz = XhtmlRendererFactory.class;
        synchronized (XhtmlRendererFactory.class) {
            if (instance == null) {
                instance = new XhtmlRendererFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public XhtmlRendererFactory() {
        InputStream resourceAsStream = this.getClass().getResourceAsStream(fileName);
        try {
            Properties props = new Properties();
            props.load(resourceAsStream);
            this.classNames.putAll(props);
            resourceAsStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Renderer getRenderer(String type) {
        Object object;
        Renderer renderer = com.uwyn.jhighlight.renderer.XhtmlRendererFactory.getRenderer((String)type);
        if (renderer == null && (object = this.classNames.get(type.toLowerCase())) != null) {
            String className = object.toString();
            try {
                Class<?> class1 = Class.forName(className);
                Object newInstance = class1.newInstance();
                if (newInstance instanceof Renderer) {
                    return (Renderer)newInstance;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return renderer;
    }

    public static void main(String[] args) {
        Renderer renderer = XhtmlRendererFactory.instance().getRenderer("css");
        String path = "D:\\eclipse\\rf\\rf3\\samples\\richfaces-demo\\src\\main\\webapp\\css\\common.css";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            renderer.highlight("css", (InputStream)new FileInputStream(path), (OutputStream)bos, null, true);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        renderer = XhtmlRendererFactory.instance().getRenderer("xhtml");
        try {
            renderer.highlight("bbb", (InputStream)new ByteArrayInputStream(bos.toByteArray()), (OutputStream)System.out, null, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

