/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo;

import java.net.URL;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.FacesException;
import javax.faces.bean.ApplicationScoped;
import javax.faces.bean.ManagedBean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.richfaces.demo.CountriesBean;
import org.richfaces.demo.Country;

@ManagedBean(eager=true)
@ApplicationScoped
public class CountriesBean {
    private List<Country> countries;

    @PostConstruct
    public void initialize() {
        try {
            JAXBContext countryContext = JAXBContext.newInstance((Class[])new Class[]{Countries.class});
            Unmarshaller unmarshaller = countryContext.createUnmarshaller();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URL dataUrl = classLoader.getResource("org/richfaces/demo/countries.xml");
            this.countries = ((Countries)unmarshaller.unmarshal(dataUrl)).getCountries();
        }
        catch (JAXBException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public List<Country> getCountries() {
        return this.countries;
    }
}

