/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.demo.jpa;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.richfaces.model.Arrangeable;
import org.richfaces.model.ArrangeableState;
import org.richfaces.model.DataVisitor;
import org.richfaces.model.ExtendedDataModel;
import org.richfaces.model.FilterField;
import org.richfaces.model.Range;
import org.richfaces.model.SequenceRange;
import org.richfaces.model.SortField;
import org.richfaces.model.SortOrder;

public abstract class JPADataModel<T>
extends ExtendedDataModel<T>
implements Arrangeable {
    private EntityManager entityManager;
    private Object rowKey;
    private ArrangeableState arrangeableState;
    private Class<T> entityClass;

    public JPADataModel(EntityManager entityManager, Class<T> entityClass) {
        this.entityManager = entityManager;
        this.entityClass = entityClass;
    }

    public void arrange(FacesContext context, ArrangeableState state) {
        this.arrangeableState = state;
    }

    public void setRowKey(Object key) {
        this.rowKey = key;
    }

    public Object getRowKey() {
        return this.rowKey;
    }

    private CriteriaQuery<Long> createCountCriteriaQuery() {
        CriteriaQuery criteriaQuery;
        Root root;
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        Expression filterCriteria = this.createFilterCriteria(criteriaBuilder, root = (criteriaQuery = criteriaBuilder.createQuery(Long.class)).from(this.entityClass));
        if (filterCriteria != null) {
            criteriaQuery.where(filterCriteria);
        }
        Expression count = criteriaBuilder.count((Expression)root);
        criteriaQuery.select((Selection)count);
        return criteriaQuery;
    }

    private CriteriaQuery<T> createSelectCriteriaQuery() {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.entityClass);
        Root root = criteriaQuery.from(this.entityClass);
        if (this.arrangeableState != null) {
            Expression filterCriteria;
            List orders = this.createOrders(criteriaBuilder, root);
            if (!orders.isEmpty()) {
                criteriaQuery.orderBy(orders);
            }
            if ((filterCriteria = this.createFilterCriteria(criteriaBuilder, root)) != null) {
                criteriaQuery.where(filterCriteria);
            }
        }
        return criteriaQuery;
    }

    private List<Order> createOrders(CriteriaBuilder criteriaBuilder, Root<T> root) {
        ArrayList orders = Lists.newArrayList();
        List sortFields = this.arrangeableState.getSortFields();
        if (sortFields != null && !sortFields.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            for (SortField sortField : sortFields) {
                Order jpaOrder;
                String propertyName = (String)sortField.getSortBy().getValue(facesContext.getELContext());
                Path expression = root.get(propertyName);
                SortOrder sortOrder = sortField.getSortOrder();
                if (sortOrder == SortOrder.ascending) {
                    jpaOrder = criteriaBuilder.asc((Expression)expression);
                } else if (sortOrder == SortOrder.descending) {
                    jpaOrder = criteriaBuilder.desc((Expression)expression);
                } else {
                    throw new IllegalArgumentException(sortOrder.toString());
                }
                orders.add(jpaOrder);
            }
        }
        return orders;
    }

    protected ArrangeableState getArrangeableState() {
        return this.arrangeableState;
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected Expression<Boolean> createFilterCriteriaForField(String propertyName, Object filterValue, Root<T> root, CriteriaBuilder criteriaBuilder) {
        String stringFilterValue = (String)filterValue;
        if (Strings.isNullOrEmpty((String)stringFilterValue)) {
            return null;
        }
        stringFilterValue = stringFilterValue.toLowerCase(this.arrangeableState.getLocale());
        Path expression = root.get(propertyName);
        Expression locator = criteriaBuilder.locate(criteriaBuilder.lower((Expression)expression), stringFilterValue);
        return criteriaBuilder.gt(locator, (Number)0);
    }

    private Expression<Boolean> createFilterCriteria(CriteriaBuilder criteriaBuilder, Root<T> root) {
        Expression filterCriteria = null;
        List filterFields = this.arrangeableState.getFilterFields();
        if (filterFields != null && !filterFields.isEmpty()) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            for (FilterField filterField : filterFields) {
                Object filterValue;
                String propertyName = (String)filterField.getFilterExpression().getValue(facesContext.getELContext());
                Expression predicate = this.createFilterCriteriaForField(propertyName, filterValue = filterField.getFilterValue(), root, criteriaBuilder);
                if (predicate == null) continue;
                if (filterCriteria == null) {
                    filterCriteria = predicate.as(Boolean.class);
                    continue;
                }
                filterCriteria = criteriaBuilder.and(filterCriteria, predicate.as(Boolean.class));
            }
        }
        return filterCriteria;
    }

    public void walk(FacesContext context, DataVisitor visitor, Range range, Object argument) {
        CriteriaQuery criteriaQuery = this.createSelectCriteriaQuery();
        TypedQuery query = this.entityManager.createQuery(criteriaQuery);
        SequenceRange sequenceRange = (SequenceRange)range;
        if (sequenceRange.getFirstRow() >= 0 && sequenceRange.getRows() > 0) {
            query.setFirstResult(sequenceRange.getFirstRow());
            query.setMaxResults(sequenceRange.getRows());
        }
        List data = query.getResultList();
        for (Object t : data) {
            visitor.process(context, this.getId(t), argument);
        }
    }

    public boolean isRowAvailable() {
        return this.rowKey != null;
    }

    public int getRowCount() {
        CriteriaQuery criteriaQuery = this.createCountCriteriaQuery();
        return ((Long)this.entityManager.createQuery(criteriaQuery).getSingleResult()).intValue();
    }

    public T getRowData() {
        return (T)this.entityManager.find(this.entityClass, this.rowKey);
    }

    public int getRowIndex() {
        return -1;
    }

    public void setRowIndex(int rowIndex) {
        throw new UnsupportedOperationException();
    }

    public Object getWrappedData() {
        throw new UnsupportedOperationException();
    }

    public void setWrappedData(Object data) {
        throw new UnsupportedOperationException();
    }

    protected abstract Object getId(T var1);
}

