/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.example;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.richfaces.example.ArrayNodeList;
import org.richfaces.example.ParsingException;
import org.richfaces.example.XMLBodySerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class XMLBody {
    private Document xmlDocument;
    private Element rootElement;

    public void loadXML(InputStream input) throws ParsingException {
        this.loadXML(input, false);
    }

    public void loadXML(InputStream input, boolean namespaceAware) throws ParsingException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setIgnoringElementContentWhitespace(true);
            docFactory.setValidating(false);
            docFactory.setNamespaceAware(namespaceAware);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((EntityResolver)new /* Unavailable Anonymous Inner Class!! */);
            this.xmlDocument = docBuilder.parse(input);
            this.rootElement = this.xmlDocument.getDocumentElement();
        }
        catch (Exception e) {
            throw new ParsingException("Error load XML ", (Throwable)e);
        }
    }

    public boolean isRootName(String name) {
        return this.rootElement.getNodeName().equals(name);
    }

    public String getDoctype() {
        DocumentType doctype = this.xmlDocument.getDoctype();
        if (null != doctype) {
            return doctype.getName();
        }
        return null;
    }

    public String getPiblicId() {
        DocumentType doctype = this.xmlDocument.getDoctype();
        if (null != doctype) {
            return doctype.getPublicId();
        }
        return null;
    }

    public String getRootTypeName() {
        return this.rootElement.getSchemaTypeInfo().getTypeName();
    }

    public String getContent() throws ParsingException {
        NodeList childNodes = this.rootElement.getChildNodes();
        return this.serializeNodes(childNodes);
    }

    private String serializeNodes(NodeList childNodes) throws ParsingException {
        try {
            return new XMLBodySerializer().serialize(childNodes, this.xmlDocument);
        }
        catch (Exception e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public String getContent(String xpath) throws ParsingException {
        return this.serializeNodes(this.getByXpath(xpath));
    }

    public NodeList getByXpath(String xpath) throws ParsingException {
        NodeList childNodes;
        XPath path = XPathFactory.newInstance().newXPath();
        try {
            childNodes = (NodeList)path.evaluate(xpath, this.xmlDocument, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ParsingException("Error evaluate xpath", (Throwable)e);
        }
        return childNodes;
    }

    public NodeList getByXpathUnique(String xpath, String keyXPath, Set<String> keySet) throws ParsingException {
        if (keyXPath == null) {
            return this.getByXpath(xpath);
        }
        XPath path = XPathFactory.newInstance().newXPath();
        try {
            NodeList childNodes = this.getByXpath(xpath);
            ArrayList<Node> nodeSet = new ArrayList<Node>();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node node = childNodes.item(i).cloneNode(true);
                String key = this.serializeNodes((NodeList)path.evaluate(keyXPath, node, XPathConstants.NODESET));
                if (keySet.contains(key)) continue;
                keySet.add(key);
                nodeSet.add(node);
            }
            return new ArrayNodeList(nodeSet.toArray(new Node[nodeSet.size()]));
        }
        catch (XPathExpressionException e) {
            throw new ParsingException("Error evaluate xpath", (Throwable)e);
        }
    }

    public String getContentUnique(String xpath, String keyXPath, Set<String> keySet) throws ParsingException {
        return this.serializeNodes(this.getByXpathUnique(xpath, keyXPath, keySet));
    }
}

