/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.model.UploadedFile;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.AlbumEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ImageEvent;
import org.richfaces.photoalbum.event.ShelfEvent;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.util.FileUtils;
import org.richfaces.photoalbum.util.ImageDimension;

@Named
@ApplicationScoped
public class FileManager {
    @Inject
    private File uploadRoot;
    @Inject
    private String uploadRootPath;
    @Inject
    User user;

    @PostConstruct
    public void create() {
    }

    public File getFileByPath(String path) {
        if (this.uploadRoot != null) {
            File result = new File(this.uploadRoot, path);
            try {
                String resultCanonicalPath = result.getCanonicalPath();
                if (!resultCanonicalPath.startsWith(this.uploadRootPath)) {
                    result = null;
                }
                return result;
            }
            catch (IOException e) {
                result = null;
                return result;
            }
        }
        return null;
    }

    public void onAlbumDeleted(@Observes @EventType(value=Events.ALBUM_DELETED_EVENT) AlbumEvent ae) {
        if (this.user == null) {
            return;
        }
        this.deleteDirectory(ae.getPath());
    }

    public void onShelfDeleted(@Observes @EventType(value=Events.SHELF_DELETED_EVENT) ShelfEvent se) {
        if (this.user == null) {
            return;
        }
        this.deleteDirectory(se.getPath());
    }

    public void onUserDeleted(@Observes @EventType(value=Events.USER_DELETED_EVENT) SimpleEvent se) {
        this.deleteDirectory(this.user.getPath());
    }

    public void onShelfAdded(@Observes @EventType(value=Events.SHELF_ADDED_EVENT) ShelfEvent se) {
        File directory = this.getFileByPath(se.getShelf().getPath());
        FileUtils.addDirectory((File)directory);
    }

    public void onAlbumAdded(@Observes @EventType(value=Events.ALBUM_ADDED_EVENT) AlbumEvent ae) {
        File directory = this.getFileByPath(ae.getAlbum().getPath());
        FileUtils.addDirectory((File)directory);
    }

    public boolean saveAvatar(File avatarData, User user) {
        String avatarPath = File.separator + user.getLogin() + File.separator + "avatar.jpg";
        this.createDirectoryIfNotExist(avatarPath);
        try {
            FileInputStream is = new FileInputStream(avatarData);
            return this.writeFile(avatarPath, (InputStream)is, "", 80, true);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void deleteImage(@Observes @EventType(value=Events.IMAGE_DELETED_EVENT) ImageEvent ie) {
        if (this.user == null) {
            return;
        }
        for (ImageDimension d : ImageDimension.values()) {
            FileUtils.deleteFile((File)this.getFileByPath(this.transformPath(ie.getPath(), d.getFilePostfix())));
        }
    }

    public boolean addImage(String fileName, UploadedFile file) throws IOException {
        if (this.user == null) {
            return false;
        }
        this.createDirectoryIfNotExist(fileName);
        for (ImageDimension d : ImageDimension.values()) {
            if (this.writeFile(fileName, file.getInputStream(), d.getFilePostfix(), d.getX(), true)) continue;
            return false;
        }
        return true;
    }

    public String transformPath(String target, String substitute) {
        if (target.length() < 2 || target.lastIndexOf(".") == -1) {
            return "";
        }
        String begin = target.substring(0, target.lastIndexOf("."));
        String end = target.substring(target.lastIndexOf("."));
        return begin + substitute + end;
    }

    public File getFileByAbsolutePath(String path) {
        return new File(path);
    }

    public boolean isDirectoryPresent(String path) {
        File file = this.getFileByPath(path);
        return file.exists() && file.isDirectory();
    }

    public boolean isFilePresent(String path) {
        File file = this.getFileByPath(path);
        return file.exists();
    }

    public void renameAlbumDirectory(@Observes @EventType(value=Events.ALBUM_DRAGGED_EVENT) AlbumEvent ae) {
        String pathOld = ae.getPath();
        Album album = ae.getAlbum();
        File file = this.getFileByPath(pathOld);
        File file2 = this.getFileByPath(album.getPath());
        if (file2.exists()) {
            if (file2.isDirectory()) {
                FileUtils.deleteDirectory((File)file2, (boolean)false);
            } else {
                FileUtils.deleteFile((File)file2);
            }
        }
        file.renameTo(file2);
    }

    public void renameImageFile(@Observes @EventType(value=Events.IMAGE_DRAGGED_EVENT) ImageEvent ie) {
        File file = null;
        File file2 = null;
        String pathOld = ie.getPath();
        Image image = ie.getImage();
        for (ImageDimension dimension : ImageDimension.values()) {
            file = this.getFileByPath(this.transformPath(pathOld, dimension.getFilePostfix()));
            file2 = this.getFileByPath(this.transformPath(image.getFullPath(), dimension.getFilePostfix()));
            if (file2.exists()) {
                if (file2.isDirectory()) {
                    FileUtils.deleteDirectory((File)file2, (boolean)false);
                } else {
                    FileUtils.deleteFile((File)file2);
                }
            }
            file.renameTo(file2);
        }
    }

    private boolean writeFile(String newFileName, InputStream inputStream, String pattern, int size, boolean includeUploadRoot) {
        BufferedImage bsrc = null;
        try {
            bsrc = FileUtils.bitmapToImage((InputStream)inputStream, (String)"JPG");
        }
        catch (IOException e1) {
            return false;
        }
        int resizedParam = bsrc.getWidth() > bsrc.getHeight() ? bsrc.getWidth() : bsrc.getHeight();
        double scale = (double)size / (double)resizedParam;
        Double widthInDouble = Double.valueOf(scale) * (double)bsrc.getWidth();
        int width = widthInDouble.intValue();
        Double heightInDouble = Double.valueOf(scale) * (double)bsrc.getHeight();
        int height = heightInDouble.intValue();
        if (width > bsrc.getWidth() || height > bsrc.getHeight() || size == 0) {
            width = bsrc.getWidth();
            height = bsrc.getHeight();
        }
        BufferedImage bdest = FileUtils.getScaledInstance((BufferedImage)bsrc, (int)width, (int)height, (Object)RenderingHints.VALUE_INTERPOLATION_BICUBIC, (boolean)true);
        String dest = includeUploadRoot ? this.uploadRootPath + this.transformPath(newFileName, pattern) : this.transformPath(newFileName, pattern);
        try {
            FileUtils.imageToBitmap((BufferedImage)bdest, (String)dest, (String)"JPG");
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    private void deleteDirectory(String directory) {
        File file = this.getFileByPath(directory);
        FileUtils.deleteDirectory((File)file, (boolean)false);
    }

    private void createDirectoryIfNotExist(String fileNameNew) {
        String directory;
        File file;
        int lastIndexOf = fileNameNew.lastIndexOf(File.separator);
        if (lastIndexOf > 0 && !(file = this.getFileByPath(directory = fileNameNew.substring(0, lastIndexOf))).exists()) {
            file.mkdirs();
        }
    }
}

