/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpSession;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.util.Preferred;

public class Utils {
    @Produces
    @PersistenceContext
    private EntityManager em;
    @Inject
    @EventType(value=Events.CHECK_USER_EXPIRED_EVENT)
    Event<SimpleEvent> event;

    private Utils() {
    }

    public static void addFacesMessage(String componentId, String message) {
        UIViewRoot root = FacesContext.getCurrentInstance().getViewRoot();
        UIComponent component = root.findComponent(componentId);
        FacesContext.getCurrentInstance().addMessage(component.getClientId(FacesContext.getCurrentInstance()), new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
    }

    @Produces
    @Preferred
    public static HttpSession getSession() {
        return (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
    }

    public static void addToRerender(String componentId) {
        try {
            FacesContext fc = FacesContext.getCurrentInstance();
            ExtendedPartialViewContext epvc = ExtendedPartialViewContext.getInstance((FacesContext)fc);
            UIComponent uIComponent = fc.getViewRoot().findComponent(componentId);
        }
        catch (Exception e) {
            System.err.print(e.getMessage());
        }
    }

    public void fireCheckUserExpiredEvent() {
        this.event.fire((Object)new SimpleEvent());
    }
}

