/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.service;

import java.util.HashSet;
import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Comment;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.MetaTag;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.service.IImageAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class ImageAction
implements IImageAction {
    @Inject
    EntityManager em;

    public void deleteImage(Image image) throws PhotoAlbumException {
        Album parentAlbum = image.getAlbum();
        try {
            parentAlbum.removeImage(image);
            image.setImageTags(null);
            this.em.remove(this.em.merge((Object)image));
            this.em.flush();
        }
        catch (Exception e) {
            parentAlbum.addImage(image);
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void editImage(Image image, boolean metatagsChanged) throws PhotoAlbumException {
        try {
            if (metatagsChanged) {
                String tagsByImageId = "select m from MetaTag m join m.images i where i.id = :id";
                List pointsToImage = this.em.createQuery(tagsByImageId, MetaTag.class).setParameter("id", (Object)image.getId()).getResultList();
                List imageTags = image.getImageTags();
                for (MetaTag m : pointsToImage) {
                    if (imageTags.contains(m)) continue;
                    this.removeMetaTag(image, m);
                }
                for (MetaTag m : imageTags) {
                    if (m.getImages().contains(image)) continue;
                    this.addMetaTag(image, m);
                }
                String[] tokens = image.getMetaString().split(",");
                HashSet<String> toks = new HashSet<String>();
                for (String s : tokens) {
                    if ("".equals(s)) continue;
                    toks.add(s.trim());
                }
                for (String s : toks) {
                    MetaTag t = image.getTagByName(s);
                    t = this.getTagByName(s);
                    if (t != null) {
                        image.addMetaTag(t);
                        continue;
                    }
                    t = new MetaTag();
                    t.setTag(s);
                    image.addMetaTag(t);
                    this.em.persist((Object)t);
                }
                if (image.isCovering()) {
                    if (!image.equals((Object)image.getAlbum().getCoveringImage())) {
                        image.getAlbum().setCoveringImage(image);
                    }
                } else if (image.equals((Object)image.getAlbum().getCoveringImage())) {
                    image.getAlbum().setCoveringImage((Image)image.getAlbum().getImages().get(0));
                }
            }
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void addImage(Image image) throws PhotoAlbumException {
        try {
            this.em.persist((Object)image);
            image.getAlbum().addImage(image);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void deleteComment(Comment comment) throws PhotoAlbumException {
        try {
            Image image = comment.getImage();
            image.removeComment(comment);
            this.em.remove(this.em.merge((Object)comment));
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void addComment(Comment comment) throws PhotoAlbumException {
        Image image = comment.getImage();
        if (!image.isAllowComments()) {
            throw new PhotoAlbumException("Cannot add comments to this image");
        }
        try {
            image.addComment(comment);
            this.em.persist((Object)comment);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void addMetaTag(Image image, MetaTag metaTag) throws PhotoAlbumException {
        try {
            if (this.getTagByName(metaTag.getTag()) == null) {
                this.em.persist((Object)metaTag);
            }
            image.addMetaTag(metaTag);
            metaTag.addImage(image);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public void removeMetaTag(Image image, MetaTag metaTag) throws PhotoAlbumException {
        try {
            image.removeMetaTag(metaTag);
            metaTag.removeImage(image);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public MetaTag getTagByName(String tag) {
        MetaTag t;
        try {
            t = (MetaTag)this.em.createNamedQuery("tag-byName").setParameter("tag", (Object)tag).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
        return t;
    }

    public List<MetaTag> getPopularTags() {
        return this.em.createNamedQuery("tag-popular").setMaxResults(20).getResultList();
    }

    public List<MetaTag> getTagsLikeString(String suggest) {
        return this.em.createNamedQuery("tag-suggest").setParameter("tag", (Object)(suggest.toLowerCase() + "%")).getResultList();
    }

    public boolean isImageWithThisPathExist(Album album, String path) {
        return this.em.createNamedQuery("image-exist").setParameter("path", (Object)path).setParameter("album", (Object)album).getResultList().size() != 0;
    }

    public Long getCountIdenticalImages(Album album, String path) {
        return (Long)this.em.createNamedQuery("image-countIdenticalImages").setParameter("path", (Object)(path + "%")).setParameter("album", (Object)album).getSingleResult();
    }

    public List<Comment> findAllUserComments(User user) {
        return this.em.createNamedQuery("user-comments").setParameter("author", (Object)user).getResultList();
    }

    public void resetImage(Image image) {
        this.em.refresh((Object)image);
    }
}

