/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ejbsearch;

import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.ejbsearch.SearchBothAlbumsStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchBothImagesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchBothShelvesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchEntityEnum;
import org.richfaces.photoalbum.ejbsearch.SearchMetatagsStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchMyAlbumsStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchMyImagesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchMyShelvesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchQueryFactory;
import org.richfaces.photoalbum.ejbsearch.SearchSharedAlbumsStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchSharedImagesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchSharedShelvesStrategy;
import org.richfaces.photoalbum.ejbsearch.SearchUserStrategy;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@ApplicationScoped
public class SearchQueryFactory {
    @Inject
    EntityManager em;

    public Query getQuery(SearchEntityEnum entity, User user, boolean searchInShared, boolean searchInMy, String queryString) throws PhotoAlbumException {
        SearchUserStrategy strategy = null;
        HashMap<String, User> parameters = new HashMap<String, User>();
        parameters.put("user", user);
        switch (1.$SwitchMap$org$richfaces$photoalbum$ejbsearch$SearchEntityEnum[entity.ordinal()]) {
            case 1: {
                strategy = new SearchUserStrategy();
                break;
            }
            case 2: {
                if (searchInShared && searchInMy) {
                    strategy = new SearchBothShelvesStrategy();
                    break;
                }
                if (searchInShared) {
                    strategy = new SearchSharedShelvesStrategy();
                    break;
                }
                if (searchInMy) {
                    strategy = new SearchMyShelvesStrategy();
                    break;
                }
                throw new PhotoAlbumException("Wrong search parameters");
            }
            case 3: {
                if (searchInShared && searchInMy) {
                    strategy = new SearchBothAlbumsStrategy();
                    break;
                }
                if (searchInShared) {
                    strategy = new SearchSharedAlbumsStrategy();
                    break;
                }
                if (searchInMy) {
                    strategy = new SearchMyAlbumsStrategy();
                    break;
                }
                throw new PhotoAlbumException("Wrong search parameters");
            }
            case 4: {
                if (searchInShared && searchInMy) {
                    strategy = new SearchBothImagesStrategy();
                    break;
                }
                if (searchInShared) {
                    strategy = new SearchSharedImagesStrategy();
                    break;
                }
                if (searchInMy) {
                    strategy = new SearchMyImagesStrategy();
                    break;
                }
                throw new PhotoAlbumException("Wrong search parameters");
            }
            case 5: {
                strategy = new SearchMetatagsStrategy();
                break;
            }
            default: {
                throw new PhotoAlbumException("Wrong search parameters");
            }
        }
        return strategy.getQuery(this.em, parameters, queryString);
    }
}

