/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.service;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.bean.UserBean;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.service.IUserAction;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class UserAction
implements IUserAction {
    @Inject
    EntityManager em;
    @Inject
    UserBean userBean;

    public void register(User user) throws PhotoAlbumException {
        try {
            this.em.persist((Object)user);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public User updateUser() throws PhotoAlbumException {
        try {
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
        return this.userBean.getUser();
    }

    public User refreshUser() {
        User user = (User)this.em.find(User.class, (Object)this.userBean.getUser().getId());
        this.em.refresh((Object)user);
        return user;
    }

    public boolean isUserExist(String login) {
        return this.em.createNamedQuery("user-exist").setParameter("login", (Object)login).getResultList().size() != 0;
    }

    public boolean isEmailExist(String email) {
        return this.em.createNamedQuery("email-exist").setParameter("email", (Object)email).getResultList().size() != 0;
    }
}

