/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.bean;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.util.Preferred;

@Named
@ApplicationScoped
public class UserBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    EntityManager em;
    private User user;
    private String username;
    private String password;
    private boolean logged = false;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User logIn(String username, String passwordHash) throws Exception {
        this.user = (User)this.em.createNamedQuery("user-login").setParameter("username", (Object)username).setParameter("password", (Object)passwordHash).getSingleResult();
        this.logged = this.user != null;
        return this.user;
    }

    @Produces
    @Preferred
    public User getUser() {
        if (!this.logged) {
            return null;
        }
        return this.user;
    }

    public void refreshUser() {
        if (this.logged) {
            this.user = (User)this.em.createNamedQuery("user-login").setParameter("username", (Object)this.user.getLogin()).setParameter("password", (Object)this.user.getPasswordHash()).getSingleResult();
            this.logged = this.user != null;
        }
    }

    public boolean isLoggedIn() {
        return this.logged;
    }

    public void logout() {
        this.user = null;
        this.logged = false;
    }

    public void reset() {
        this.username = "";
        this.password = "";
    }
}

