/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.MetaTag;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.EventTypeQualifier;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.NavEvent;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.NavigationEnum;

@Named
@ApplicationScoped
public class Model
implements Serializable {
    private static final long serialVersionUID = -1767281809514660171L;
    private Image selectedImage;
    private Album selectedAlbum;
    private User selectedUser;
    private Shelf selectedShelf;
    private MetaTag selectedTag;
    private NavigationEnum mainArea = NavigationEnum.ANONYM;
    private List<Image> images;
    @Inject
    @Any
    Event<SimpleEvent> event;
    @Inject
    MetaTag metatag;

    public void resetModel(NavigationEnum mainArea, User selectedUser, Shelf selectedShelf, Album selectedAlbum, Image selectedImage, List<Image> images) {
        this.setSelectedAlbum(selectedAlbum);
        this.setSelectedImage(selectedImage);
        this.setSelectedShelf(selectedShelf);
        this.setSelectedUser(selectedUser);
        this.mainArea = mainArea;
        this.images = images;
    }

    public void setMainArea(@Observes @EventType(value=Events.UPDATE_MAIN_AREA_EVENT) NavEvent ne) {
        if (this.mainArea != null && this.mainArea.equals((Object)NavigationEnum.FILE_UPLOAD)) {
            this.event.select(new Annotation[]{new EventTypeQualifier(Events.CLEAR_FILE_UPLOAD_EVENT)}).fire((Object)new SimpleEvent());
        }
        this.mainArea = ne.getNav();
    }

    public void setSelectedTag(MetaTag tag) {
        this.selectedTag = tag;
    }

    public void observeSelectedTag(@Observes @EventType(value=Events.UPDATE_SELECTED_TAG_EVENT) SimpleEvent se) {
        this.selectedTag = this.metatag;
    }

    public NavigationEnum getMainArea() {
        return this.mainArea;
    }

    public Image getSelectedImage() {
        return this.selectedImage;
    }

    private void setSelectedImage(Image selectedImage) {
        this.selectedImage = selectedImage;
    }

    public Album getSelectedAlbum() {
        return this.selectedAlbum;
    }

    public void setSelectedAlbum(Album selectedAlbum) {
        this.selectedAlbum = selectedAlbum;
    }

    public User getSelectedUser() {
        return this.selectedUser;
    }

    private void setSelectedUser(User selectedUser) {
        this.selectedUser = selectedUser;
    }

    public Shelf getSelectedShelf() {
        return this.selectedShelf;
    }

    private void setSelectedShelf(Shelf selectedShelf) {
        this.selectedShelf = selectedShelf;
    }

    public MetaTag getSelectedTag() {
        return this.selectedTag;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }
}

