/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ejbsearch;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.MetaTag;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.ejbsearch.ISearchAction;
import org.richfaces.photoalbum.ejbsearch.SearchEntityEnum;
import org.richfaces.photoalbum.ejbsearch.SearchQueryFactory;
import org.richfaces.photoalbum.service.PhotoAlbumException;

@Stateless
public class SearchAction
implements ISearchAction {
    @Inject
    EntityManager em;
    @Inject
    SearchQueryFactory searchQueryFactory;
    @Inject
    private User user;

    public List<Album> searchByAlbum(String searchQuery, boolean searchInMyAlbums, boolean searchInShared) throws PhotoAlbumException {
        Query query = this.searchQueryFactory.getQuery(SearchEntityEnum.ALBUM, this.user, searchInShared, searchInMyAlbums, searchQuery);
        if (null == query) {
            throw new PhotoAlbumException("Wrong search parameters");
        }
        return query.getResultList();
    }

    public List<Image> searchByImage(String searchQuery, boolean searchInMyAlbums, boolean searchInShared) throws PhotoAlbumException {
        Query query = this.searchQueryFactory.getQuery(SearchEntityEnum.IMAGE, this.user, searchInShared, searchInMyAlbums, searchQuery);
        if (null == query) {
            throw new PhotoAlbumException("Wrong search parameters");
        }
        return query.getResultList();
    }

    public List<User> searchByUsers(String searchQuery, boolean searchInMyAlbums, boolean searchInShared) throws PhotoAlbumException {
        Query query = this.searchQueryFactory.getQuery(SearchEntityEnum.USER, this.user, searchInShared, searchInMyAlbums, searchQuery);
        if (null == query) {
            throw new PhotoAlbumException("Wrong search parameters");
        }
        return query.getResultList();
    }

    public List<MetaTag> searchByTags(String searchQuery, boolean searchInMyAlbums, boolean searchInShared) throws PhotoAlbumException {
        Query query = this.searchQueryFactory.getQuery(SearchEntityEnum.METATAG, this.user, searchInShared, searchInMyAlbums, searchQuery);
        if (null == query) {
            throw new PhotoAlbumException("Wrong search parameters");
        }
        return query.getResultList();
    }

    public List<Shelf> searchByShelves(String searchQuery, boolean searchInMyAlbums, boolean searchInShared) throws PhotoAlbumException {
        Query query = this.searchQueryFactory.getQuery(SearchEntityEnum.SHELF, this.user, searchInShared, searchInMyAlbums, searchQuery);
        if (null == query) {
            throw new PhotoAlbumException("Wrong search parameters");
        }
        return query.getResultList();
    }
}

