/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.component.UITree;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.MetaTag;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.AlbumEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.EventTypeQualifier;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ImageEvent;
import org.richfaces.photoalbum.event.ShelfEvent;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.util.Preferred;

@Named
@ConversationScoped
public class Controller
implements Serializable {
    private static final long serialVersionUID = 5656562187249324512L;
    @Inject
    Model model;
    User user;
    @Inject
    @Preferred
    User loggedUser;
    @Inject
    FileManager fileManager;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<SimpleEvent> error;
    @Inject
    @Any
    Event<SimpleEvent> event;
    private int currentPage = 0;

    public void selectPublicShelves() {
        this.model.resetModel(NavigationEnum.ANONYM, this.user, null, null, null, null);
    }

    public void selectShelves() {
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.loggedUser, null, null, null, null);
    }

    public void selectAlbums() {
        this.model.resetModel(NavigationEnum.ALL_ALBUMS, this.loggedUser, null, null, null, null);
    }

    public void selectImages() {
        this.model.resetModel(NavigationEnum.ALL_IMAGES, this.loggedUser, null, null, null, this.loggedUser.getImages());
    }

    public void startEditShelf(Shelf shelf) {
        if (this.loggedUser == null) {
            return;
        }
        if (!this.canViewShelf(shelf)) {
            this.showError("You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.SHELF_EDIT, shelf.getOwner(), shelf, null, null, null);
    }

    public void cancelEditShelf() {
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, this.model.getSelectedShelf().getOwner(), this.model.getSelectedShelf(), null, null, null);
    }

    public void showAlbum(Album album) {
        if (!this.canViewAlbum(album)) {
            this.showError("You have no rights to view this album");
            return;
        }
        if (!this.fileManager.isDirectoryPresent(album.getPath())) {
            this.showError("This album has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.SHELF_PREVIEW, album.getOwner(), album.getShelf(), null, null, null);
            return;
        }
        this.setPage(Integer.valueOf(0));
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, album.getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void resetFileUpload() {
        this.pushEvent(Events.CLEAR_FILE_UPLOAD_EVENT);
    }

    public void showImage(Image image) {
        this.pushEvent(Events.CLEAR_EDITOR_EVENT);
        if (!this.canViewImage(image)) {
            this.showError("You have no rights to view this album");
            return;
        }
        if (!this.fileManager.isFilePresent(image.getFullPath())) {
            this.showError("This image has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, image.getAlbum().getOwner(), image.getAlbum().getShelf(), image.getAlbum(), null, image.getAlbum().getImages());
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, image.getAlbum().getOwner(), image.getAlbum().getShelf(), image.getAlbum(), image, image.getAlbum().getImages());
        image.setVisited(true);
    }

    public void startEditImage(Image image) {
        if (this.loggedUser == null) {
            return;
        }
        if (!this.canViewImage(image)) {
            this.showError("You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_EDIT, image.getOwner(), image.getAlbum().getShelf(), image.getAlbum(), image, image.getAlbum().getImages());
    }

    public void editUser() {
        if (this.loggedUser == null) {
            return;
        }
        this.pushEvent(Events.EDIT_USER_EVENT);
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.user, this.model.getSelectedShelf(), this.model.getSelectedAlbum(), this.model.getSelectedImage(), this.model.getImages());
    }

    public void cancelEditUser() {
        this.pushEvent(Events.CANCEL_EDIT_USER_EVENT);
        this.model.resetModel(NavigationEnum.ANONYM, this.user, null, null, null, null);
    }

    public void cancelEditImage() {
        this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, this.model.getSelectedImage().getAlbum().getShelf().getOwner(), this.model.getSelectedImage().getAlbum().getShelf(), this.model.getSelectedImage().getAlbum(), this.model.getSelectedImage(), this.model.getSelectedImage().getAlbum().getImages());
    }

    public void showShelf(Shelf shelf) {
        if (!this.fileManager.isDirectoryPresent(shelf.getPath())) {
            this.showError("This shelf has been recently deleted. Please, refresh your browser to see actual data.");
            this.model.resetModel(NavigationEnum.ANONYM, shelf.getOwner(), null, null, null, null);
            return;
        }
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void startEditAlbum(Album album) {
        if (this.loggedUser == null) {
            return;
        }
        if (!album.isOwner(this.loggedUser)) {
            this.showError("You have no rights to view this album");
            return;
        }
        this.model.resetModel(NavigationEnum.ALBUM_EDIT, album.getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void cancelEditAlbum() {
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.model.getSelectedAlbum().getOwner(), this.model.getSelectedAlbum().getShelf(), this.model.getSelectedAlbum(), null, this.model.getSelectedAlbum().getImages());
    }

    public void onAlbumAdded(@Observes @EventType(value=Events.ALBUM_ADDED_EVENT) AlbumEvent ae) {
        Album album = ae.getAlbum();
        if (album.isShowAfterCreate()) {
            this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, album.getOwner(), album.getShelf(), album, null, album.getImages());
        }
    }

    public void onAlbumEdited(@Observes @EventType(value=Events.ALBUM_EDITED_EVENT) AlbumEvent ae) {
        Album album = ae.getAlbum();
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.model.getSelectedUser(), this.model.getSelectedShelf(), album, null, album.getImages());
    }

    public void onAlbumDeleted(@Observes @EventType(value=Events.ALBUM_DELETED_EVENT) AlbumEvent ae) {
        this.model.resetModel(NavigationEnum.ALL_ALBUMS, this.model.getSelectedUser(), this.model.getSelectedShelf(), null, null, null);
    }

    public void onShelfDeleted(@Observes @EventType(value=Events.SHELF_DELETED_EVENT) ShelfEvent se) {
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.model.getSelectedUser(), null, null, null, null);
    }

    public void onShelfAdded(@Observes @EventType(value=Events.SHELF_ADDED_EVENT) ShelfEvent se) {
        Shelf shelf = se.getShelf();
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void onShelfEdited(@Observes @EventType(value=Events.SHELF_EDITED_EVENT) ShelfEvent se) {
        Shelf shelf = se.getShelf();
        this.model.resetModel(NavigationEnum.SHELF_PREVIEW, shelf.getOwner(), shelf, null, null, null);
    }

    public void onImageDeleted(@Observes @EventType(value=Events.IMAGE_DELETED_EVENT) ImageEvent ie) {
        this.model.resetModel(NavigationEnum.ALBUM_PREVIEW, this.model.getSelectedUser(), this.model.getSelectedShelf(), this.model.getSelectedAlbum(), null, this.model.getSelectedAlbum().getImages());
    }

    public void onAuthenticate(@Observes @EventType(value=Events.AUTHENTICATED_EVENT) SimpleEvent se) {
        this.model.resetModel(NavigationEnum.ALL_SHELFS, this.loggedUser, null, null, null, null);
    }

    public void showFileUpload() {
        if (this.loggedUser.getShelves().size() <= 0) {
            this.showError("You must create at least one shelf before uploading images!");
            return;
        }
        Album alb = null;
        this.model.resetModel(NavigationEnum.FILE_UPLOAD, this.loggedUser, (alb = this.setDefaultAlbumToUpload(alb)) != null ? alb.getShelf() : null, alb, null, alb != null ? alb.getImages() : null);
    }

    public void showFileUpload(Album album) {
        if (!this.isUserAlbum(album)) {
            this.showError("You can't add images to this album");
            return;
        }
        this.model.resetModel(NavigationEnum.FILE_UPLOAD, album.getShelf().getOwner(), album.getShelf(), album, null, album.getImages());
    }

    public void showSharedAlbums(User user) {
        this.model.resetModel(NavigationEnum.USER_SHARED_ALBUMS, user, null, null, null, user.getSharedImages());
    }

    public void showSharedImages(User user) {
        this.model.resetModel(NavigationEnum.USER_SHARED_IMAGES, user, null, null, null, user.getSharedImages());
    }

    public void showUser(User user) {
        this.model.resetModel(NavigationEnum.USER_PREFS, user, null, null, null, null);
    }

    public void showUnvisitedImages(Shelf shelf) {
        this.model.resetModel(NavigationEnum.SHELF_UNVISITED, shelf.getOwner(), shelf, null, null, shelf.getUnvisitedImages());
    }

    public void showUnvisitedImages(Album album) {
        this.model.resetModel(NavigationEnum.ALBUM_UNVISITED, album.getOwner(), album.getShelf(), album, null, album.getUnvisitedImages());
    }

    public void showTag(MetaTag metatag) {
        this.model.resetModel(NavigationEnum.TAGS, this.model.getSelectedUser(), this.model.getSelectedShelf(), this.model.getSelectedAlbum(), this.model.getSelectedImage(), metatag.getImages());
        this.model.setSelectedTag(metatag);
    }

    public void startRegistration(@Observes @EventType(value=Events.START_REGISTER_EVENT) SimpleEvent se) {
        this.model.resetModel(NavigationEnum.REGISTER, this.user, null, null, null, null);
    }

    public void cancelRegistration() {
        this.model.resetModel(NavigationEnum.ANONYM, this.user, null, null, null, null);
    }

    public Boolean adviseNodeSelected(UITree tree) {
        Object currentNode = tree.getRowData();
        if (currentNode.equals(this.model.getSelectedAlbum()) || currentNode.equals(this.model.getSelectedShelf())) {
            return true;
        }
        return false;
    }

    public Integer getPage() {
        if (this.currentPage == 0) {
            Integer index = this.model.getSelectedAlbum().getIndex(this.model.getSelectedImage());
            this.currentPage = index / 5 + 1;
        }
        return this.currentPage;
    }

    public void setPage(Integer page) {
        this.currentPage = page;
    }

    public boolean isUserImage(Image image) {
        if (image == null || image.getOwner() == null || this.loggedUser == null) {
            return false;
        }
        return this.loggedUser.equals((Object)image.getOwner());
    }

    public boolean isUserHaveShelves() {
        return this.loggedUser.getShelves().size() > 0;
    }

    public boolean isUserHaveAlbums() {
        return this.loggedUser.getAlbums().size() > 0;
    }

    public boolean isUserShelf(Shelf shelf) {
        return shelf != null && this.loggedUser != null && this.loggedUser.equals((Object)shelf.getOwner());
    }

    public boolean isUserAlbum(Album album) {
        return album != null && this.loggedUser != null && this.loggedUser.equals((Object)album.getOwner());
    }

    public boolean isProfileEditable(User selectedUser) {
        return selectedUser != null && selectedUser.equals((Object)this.loggedUser);
    }

    private boolean canViewShelf(Shelf shelf) {
        return shelf != null && shelf.isOwner(this.loggedUser);
    }

    private boolean canViewAlbum(Album album) {
        return album != null && album.getShelf() != null && (album.getShelf().isShared() || album.isOwner(this.loggedUser));
    }

    private boolean canViewImage(Image image) {
        return image != null && image.getAlbum() != null && image.getAlbum().getShelf() != null && (image.getAlbum().getShelf().isShared() || image.isOwner(this.loggedUser));
    }

    public void showError(String errorMessage) {
        this.error.fire((Object)new SimpleEvent(errorMessage));
    }

    private void pushEvent(Events eventType) {
        this.event.select(new Annotation[]{new EventTypeQualifier(eventType)}).fire((Object)new SimpleEvent());
    }

    private Album setDefaultAlbumToUpload(Album alb) {
        if (this.isUserAlbum(this.model.getSelectedAlbum())) {
            alb = this.model.getSelectedAlbum();
        }
        if (alb == null && this.loggedUser != null && this.loggedUser.getShelves().size() > 0 && ((Shelf)this.loggedUser.getShelves().get(0)).getAlbums().size() > 0) {
            for (Shelf s : this.loggedUser.getShelves()) {
                if (s.getAlbums().size() <= 0) continue;
                alb = (Album)s.getAlbums().get(0);
                break;
            }
        }
        return alb;
    }
}

