/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.event.DropEvent;
import org.richfaces.event.DropListener;
import org.richfaces.photoalbum.domain.Album;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.domain.Shelf;
import org.richfaces.photoalbum.domain.User;
import org.richfaces.photoalbum.event.AlbumEvent;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.ImageEvent;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.service.IAlbumAction;
import org.richfaces.photoalbum.util.Preferred;
import org.richfaces.photoalbum.util.Utils;

@Named(value="dndManager")
public class DnDManager
implements DropListener {
    @Inject
    @Preferred
    User user;
    @Inject
    FileManager fileManager;
    @Inject
    IAlbumAction albumAction;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<SimpleEvent> error;
    @Inject
    @EventType(value=Events.ALBUM_DRAGGED_EVENT)
    Event<AlbumEvent> albumEvent;
    @Inject
    @EventType(value=Events.IMAGE_DRAGGED_EVENT)
    Event<ImageEvent> imageEvent;

    public void processDrop(DropEvent dropEvent) {
        if (this.user == null) {
            return;
        }
        Object dragValue = dropEvent.getDragValue();
        Object dropValue = dropEvent.getDropValue();
        if (dragValue instanceof Image) {
            if (!((Album)dropValue).getOwner().getLogin().equals(this.user.getLogin())) {
                this.error.fire((Object)new SimpleEvent("You can't add photos to this album"));
                return;
            }
            this.handleImage((Image)dragValue, (Album)dropValue);
        } else if (dragValue instanceof Album) {
            if (!((Shelf)dropValue).getOwner().getLogin().equals(this.user.getLogin())) {
                this.error.fire((Object)new SimpleEvent("You can't add the album to this shelf"));
                return;
            }
            this.handleAlbum((Album)dragValue, (Shelf)dropValue);
        }
    }

    private void handleAlbum(Album dragValue, Shelf dropValue) {
        if (dragValue.getShelf().equals((Object)dropValue)) {
            return;
        }
        String pathOld = dragValue.getPath();
        dropValue.addAlbum(dragValue);
        try {
            this.albumAction.editAlbum(dragValue);
        }
        catch (Exception e) {
            this.error.fire((Object)new SimpleEvent("Error in DB."));
            return;
        }
        this.albumEvent.fire((Object)new AlbumEvent(dragValue, pathOld));
        Utils.addToRerender((String)"treeform");
    }

    private void handleImage(Image dragValue, Album dropValue) {
        if (dragValue.getAlbum().equals((Object)dropValue)) {
            return;
        }
        String pathOld = dragValue.getFullPath();
        dropValue.addImage(dragValue);
        try {
            this.albumAction.editAlbum(dropValue);
        }
        catch (Exception e) {
            this.error.fire((Object)new SimpleEvent("Error in DB."));
            return;
        }
        this.imageEvent.fire((Object)new ImageEvent(dragValue, pathOld));
        Utils.addToRerender((String)"treeform");
    }
}

