/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.manager;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.richfaces.photoalbum.domain.Image;
import org.richfaces.photoalbum.event.EventType;
import org.richfaces.photoalbum.event.Events;
import org.richfaces.photoalbum.event.SimpleEvent;
import org.richfaces.photoalbum.manager.FileManager;
import org.richfaces.photoalbum.manager.Model;
import org.richfaces.photoalbum.manager.NavigationEnum;
import org.richfaces.photoalbum.util.Utils;

@ApplicationScoped
@Named(value="slideshow")
public class SlideshowManager
implements Serializable {
    private static final long serialVersionUID = 7801877176558409702L;
    private Integer slideshowIndex;
    private Integer startSlideshowIndex;
    private Image selectedImage;
    private boolean active;
    private boolean errorDetected;
    @Inject
    Model model;
    @Inject
    FileManager fileManager;
    @Inject
    @EventType(value=Events.ADD_ERROR_EVENT)
    Event<SimpleEvent> error;
    private int interval = 4000;

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void startSlideshow() {
        if (!this.active) {
            this.initSlideshow();
        }
        if (this.model.getImages() == null || this.model.getImages().size() < 1) {
            this.onError(true);
            return;
        }
        if (this.selectedImage == null) {
            this.selectedImage = (Image)this.model.getImages().get(this.slideshowIndex);
        }
        this.selectedImage.setVisited(true);
        this.checkIsFileRecentlyDeleted();
    }

    public void startSlideshow(Image selectedImage) {
        this.initSlideshow();
        this.startSlideshowIndex = this.slideshowIndex = Integer.valueOf(this.model.getImages().indexOf(selectedImage));
        this.selectedImage = selectedImage;
        this.startSlideshow();
    }

    public void stopSlideshow(@Observes @EventType(value=Events.STOP_SLIDESHOW_EVENT) SimpleEvent se) {
        this.active = false;
        this.errorDetected = false;
        this.selectedImage = null;
        this.slideshowIndex = 0;
        this.startSlideshowIndex = 0;
    }

    public void stopSlideshow() {
        this.stopSlideshow(new SimpleEvent());
    }

    public Integer getSlideshowIndex() {
        return this.slideshowIndex;
    }

    public void setSlideshowIndex(Integer slideshowIndex) {
        this.slideshowIndex = slideshowIndex;
    }

    public Image getSelectedImage() {
        return this.selectedImage;
    }

    public void setSelectedImage(Image selectedImage) {
        this.selectedImage = selectedImage;
    }

    public void showNextImage() {
        if (!this.active) {
            this.onError(false);
            return;
        }
        if (this.slideshowIndex == this.model.getImages().size() - 1) {
            this.slideshowIndex = -1;
        }
        Integer n = this.slideshowIndex;
        Integer n2 = this.slideshowIndex = Integer.valueOf(this.slideshowIndex + 1);
        if (this.slideshowIndex == this.startSlideshowIndex) {
            this.onError(false);
            return;
        }
        this.selectedImage = (Image)this.model.getImages().get(this.slideshowIndex);
        this.selectedImage.setVisited(true);
        this.checkIsFileRecentlyDeleted();
    }

    public Integer getStartSlideshowIndex() {
        return this.startSlideshowIndex;
    }

    public void setStartSlideshowIndex(Integer startSlideshowIndex) {
        this.startSlideshowIndex = startSlideshowIndex;
    }

    public boolean isErrorDetected() {
        return this.errorDetected;
    }

    public void setErrorDetected(boolean errorDetected) {
        this.errorDetected = errorDetected;
    }

    private void initSlideshow() {
        this.active = true;
        this.errorDetected = false;
        this.slideshowIndex = 0;
        this.startSlideshowIndex = 0;
    }

    private void onError(boolean isShowOnUI) {
        this.stopSlideshow();
        this.errorDetected = true;
        Utils.addToRerender((String)"overForm:mainArea");
        if (isShowOnUI) {
            this.error.fire((Object)new SimpleEvent("No images for slideshow!"));
        }
    }

    private void checkIsFileRecentlyDeleted() {
        if (!this.fileManager.isFilePresent(this.selectedImage.getFullPath())) {
            this.error.fire((Object)new SimpleEvent("This image has been recently deleted. Please, refresh your browser to see actual data."));
            this.active = false;
            this.errorDetected = true;
            Utils.addToRerender((String)"overForm:mainArea");
            this.model.resetModel(NavigationEnum.ALBUM_IMAGE_PREVIEW, this.selectedImage.getAlbum().getOwner(), this.selectedImage.getAlbum().getShelf(), this.selectedImage.getAlbum(), null, this.selectedImage.getAlbum().getImages());
            return;
        }
    }
}

