/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    private static final String JPEG = "jpeg";
    private static final String JPG = "jpg";
    private static final int BUFFER_SIZE = 4096;
    private static final boolean CLOCK = true;
    private static final boolean VERIFY = true;

    public static void copyFile(File srcFile, File destFile) throws IOException {
        if (!srcFile.getPath().toLowerCase().endsWith("jpg") && !srcFile.getPath().toLowerCase().endsWith("jpeg")) {
            return;
        }
        FileInputStream in = new FileInputStream(srcFile);
        FileOutputStream out = new FileOutputStream(destFile);
        try {
            long millis = System.currentTimeMillis();
            CRC32 checksum = new CRC32();
            checksum.reset();
            byte[] buffer = new byte[4096];
            int bytesRead = ((InputStream)in).read(buffer);
            while (bytesRead >= 0) {
                checksum.update(buffer, 0, bytesRead);
                ((OutputStream)out).write(buffer, 0, bytesRead);
                bytesRead = ((InputStream)in).read(buffer);
            }
            millis = System.currentTimeMillis() - millis;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            ((OutputStream)out).close();
            ((InputStream)in).close();
        }
    }

    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        if (".svn".equals(srcDir.getName())) {
            return;
        }
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            for (String aChildren : srcDir.list()) {
                FileUtils.copyDirectory((File)new File(srcDir, aChildren), (File)new File(dstDir, aChildren));
            }
        } else {
            FileUtils.copyFile((File)srcDir, (File)dstDir);
        }
    }

    public static boolean deleteDirectory(File dir, boolean isInitialDelete) {
        if (dir.isDirectory()) {
            if (dir.exists()) {
                for (File child : dir.listFiles()) {
                    try {
                        FileUtils.deleteDirectory((File)child, (boolean)isInitialDelete);
                    }
                    catch (Exception e) {
                        if (isInitialDelete) continue;
                        return false;
                    }
                }
            }
        } else if (dir.exists()) {
            boolean bl = dir.delete();
        }
        dir.delete();
        return true;
    }

    public static String joinFiles(String ... files) {
        StringBuilder res = new StringBuilder();
        for (String file : files) {
            res.append(file).append(File.separatorChar);
        }
        return res.substring(0, res.length() - 1);
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static BufferedImage bitmapToImage(InputStream is, String format) throws IOException {
        ImageReader rdr = ImageIO.getImageReadersByFormatName(format).next();
        ImageInputStream imageInput = ImageIO.createImageInputStream(is);
        rdr.setInput(imageInput);
        BufferedImage image = rdr.read(0);
        is.close();
        return image;
    }

    public static void imageToBitmap(BufferedImage image, String data, String format) throws IOException {
        FileOutputStream inb = new FileOutputStream(data);
        ImageWriter wrt = ImageIO.getImageWritersByFormatName(format).next();
        ImageOutputStream imageInput = ImageIO.createImageOutputStream(inb);
        wrt.setOutput(imageInput);
        wrt.write(image);
        ((OutputStream)inb).close();
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public static void addDirectory(File directory) {
        if (directory.exists()) {
            FileUtils.deleteDirectory((File)directory, (boolean)false);
        }
        directory.mkdirs();
    }
}

