/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.model.SelectItem;
import org.richfaces.event.FileUploadEvent;
import org.richfaces.model.UploadedFile;
import org.richfaces.photoalbum.model.Sex;

@ManagedBean
@ViewScoped
public class UserPrefsHelper
implements Serializable {
    private static final long serialVersionUID = -1767281809514660171L;
    private File avatarData;
    private boolean edit = false;
    static final SelectItem[] sexs = new SelectItem[]{new SelectItem((Object)Sex.MALE, "Male"), new SelectItem((Object)Sex.FEMALE, "Female")};

    public boolean isEdit() {
        return this.edit;
    }

    public void setEdit(boolean edit) {
        this.edit = edit;
    }

    public SelectItem[] getSexs() {
        return sexs;
    }

    public void uploadAvatar(FileUploadEvent event) {
        UploadedFile file = event.getUploadedFile();
        try {
            File f = new File(file.getName() + "avatar");
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(file.getData());
            fos.flush();
            fos.close();
            this.avatarData = f;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public File getAvatarData() {
        return this.avatarData;
    }

    public void setAvatarData(File avatarData) {
        this.avatarData = avatarData;
    }
}

