/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util.converters;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.inject.Named;
import org.jboss.solder.beanManager.BeanManagerLocator;
import org.richfaces.photoalbum.manager.UserBean;
import org.richfaces.photoalbum.model.Album;

@Named
@RequestScoped
@FacesConverter(value="albumConverter")
public class AlbumConverter
implements Converter {
    private BeanManager getBeanManager() {
        return new BeanManagerLocator().getBeanManager();
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        BeanManager bm = this.getBeanManager();
        Bean bean = (Bean)bm.getBeans(UserBean.class, new Annotation[0]).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        UserBean userBean = (UserBean)bm.getReference(bean, UserBean.class, ctx);
        for (Album a : userBean.getUser().getAlbums()) {
            if (!a.getName().equals(value)) continue;
            return a;
        }
        return new Album();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        return ((Album)value).getName();
    }
}

