/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.util.converters;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.inject.Named;
import org.jboss.solder.beanManager.BeanManagerLocator;
import org.richfaces.photoalbum.manager.UserBean;
import org.richfaces.photoalbum.model.Shelf;

@Named
@ApplicationScoped
@FacesConverter(value="shelfConverter")
public class ShelfConverter
implements Converter {
    private BeanManager getBeanManager() {
        return new BeanManagerLocator().getBeanManager();
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        BeanManager bm = this.getBeanManager();
        Bean bean = (Bean)bm.getBeans(UserBean.class, new Annotation[0]).iterator().next();
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        UserBean userBean = (UserBean)bm.getReference(bean, UserBean.class, ctx);
        for (Shelf s : userBean.getUser().getShelves()) {
            if (!s.getName().equals(value)) continue;
            return s;
        }
        return new Shelf();
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return "";
        }
        return ((Shelf)value).getName();
    }
}

