/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;
import org.richfaces.photoalbum.model.Image;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"tag"})})
@RequestScoped
public class MetaTag
implements Serializable {
    private static final long serialVersionUID = -9065024051468971330L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(length=255, nullable=false)
    @NotNull
    @NotEmpty
    @Length(min=3, max=50)
    private String tag;
    @JsonIgnore
    @ManyToMany(mappedBy="imageTags")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<Image> images = new ArrayList();

    public MetaTag() {
    }

    public MetaTag(Long id, String tag) {
        this.id = id;
        this.tag = tag;
    }

    public Long getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public void addImage(Image image) {
        this.images.add(image);
    }

    public void removeImage(Image image) {
        this.images.remove(image);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetaTag metaTag = (MetaTag)obj;
        return (this.id == null ? metaTag.getId() == null : this.id.equals(metaTag.getId())) && this.tag.equalsIgnoreCase(metaTag.getTag());
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.tag.hashCode();
        return result;
    }

    public String toString() {
        return "{id : " + this.getId() + ", tag : " + this.getTag() + "}";
    }
}

