/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.photoalbum.model.actions;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.richfaces.photoalbum.manager.UserBean;
import org.richfaces.photoalbum.model.User;
import org.richfaces.photoalbum.model.actions.IUserAction;
import org.richfaces.photoalbum.util.PhotoAlbumException;

@Stateless
public class UserAction
implements IUserAction {
    @Inject
    EntityManager em;
    @Inject
    UserBean userBean;

    public void register(User user) throws PhotoAlbumException {
        try {
            this.em.persist((Object)user);
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
    }

    public User updateUser() throws PhotoAlbumException {
        try {
            this.em.merge((Object)this.userBean.getUser());
            this.em.flush();
        }
        catch (Exception e) {
            throw new PhotoAlbumException(e.getMessage());
        }
        this.userBean.refreshUser();
        return this.userBean.getUser();
    }

    public User refreshUser() {
        User user = (User)this.em.find(User.class, (Object)this.userBean.getUser().getId());
        this.em.refresh((Object)user);
        return user;
    }

    public boolean isUserExist(String login) {
        return this.em.createNamedQuery("user-exist").setParameter("login", (Object)login).getResultList().size() != 0;
    }

    public boolean isEmailExist(String email) {
        return this.em.createNamedQuery("email-exist").setParameter("email", (Object)email).getResultList().size() != 0;
    }
}

