/*
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.richfaces.photoalbum.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import org.richfaces.model.UploadedFile;

/**
 * A wrapper class for handling two different classes: RichFaces' UploadedFile and java.io.File
 * 
 *      UploadedFile is created from a local file when using rich:fileUploader
 *      File is created from a remote file when downloading a file from an URL
 * 
 * @author mpetrov
 *
 */

public class FileHandler {
    private File file;
    private UploadedFile uFile;
    
    private boolean isStandardFile;
    
    public FileHandler(File file) {
        if (file != null) {
            this.file = file;
            isStandardFile = true;
        }
    }
    
    public FileHandler(UploadedFile uFile) {
        if (uFile != null) {
            this.uFile = uFile;
            isStandardFile = false;
        }
    }
    
    public InputStream getInputStream() throws FileNotFoundException, IOException {
        return isStandardFile ? new FileInputStream(file) : uFile.getInputStream();
    }
    
    public String getName() {
        return isStandardFile ? file.getName() : uFile.getName();
    }
    
    public long getSize() {
        return isStandardFile ? file.length() : uFile.getSize();
    }
    
    public void delete() throws Exception {
        if (isStandardFile) {
            if (!file.delete()) {
                throw new PhotoAlbumException(Constants.FILE_DELETE_ERROR);
            }
            return;
        }
        
        uFile.delete();
    }
}
